BEGIN TRANSACTION;
CREATE TABLE "Albums" (AlbumID INTEGER PRIMARY KEY, Timeframe INTEGER, AlbumName TEXT, Genre TEXT, ArtistID INTEGER, FOREIGN KEY(ArtistID) REFERENCES Artists(ArtistID));
INSERT INTO "Albums" VALUES(1,2019,'25','Pop',1);
INSERT INTO "Albums" VALUES(2,2016,'Lemonade','R&B/Hip Hop',2);
INSERT INTO "Albums" VALUES(3,2013,'To Be Loved','Jazz',3);
INSERT INTO "Albums" VALUES(4,2018,'Captain Fantastic and The Brown Dirt Cowboy','Rock',4);
INSERT INTO "Albums" VALUES(5,2007,'FutureSex/LoveSound','R&B/Pop',5);
CREATE TABLE Artists (ArtistID INTEGER PRIMARY KEY, ArtistName TEXT);
INSERT INTO "Artists" VALUES(1,'Adele');
INSERT INTO "Artists" VALUES(2,'Beyonce');
INSERT INTO "Artists" VALUES(3,'Michael Buble');
INSERT INTO "Artists" VALUES(4,'Elton John');
INSERT INTO "Artists" VALUES(5,'Justin Timberlake');
CREATE TABLE Concerts (ConcertID INTEGER PRIMARY KEY, Date TEXT, Venue TEXT, City TEXT, Country TEXT, HeadlinerID INTEGER, OpeningActID INTEGER, FOREIGN KEY(HeadlinerID) REFERENCES Artists(ArtistID), FOREIGN KEY(OpeningActID) REFERENCES Artists(ArtistID));
INSERT INTO "Concerts" VALUES(1,'2020-12-31','Madison Square Garden','New York','USA',1,NULL);
INSERT INTO "Concerts" VALUES(2,'2021-01-15','Staples Center','Los Angeles','USA',2,NULL);
INSERT INTO "Concerts" VALUES(3,'2021-02-10','O2 Arena','London','UK',3,NULL);
INSERT INTO "Concerts" VALUES(4,'2021-02-20','Barclays Centre','Brooklyn','USA',4,NULL);
INSERT INTO "Concerts" VALUES(5,'2021-03-05','Sydney Opera House','Sydney','Australia',5,NULL);
CREATE TABLE MusicLabels (LabelID INTEGER PRIMARY KEY, LabelName TEXT, ArtistID INTEGER, FOREIGN KEY(ArtistID) REFERENCES Artists(ArtistID));
INSERT INTO "MusicLabels" VALUES(1,'XL Recordings',1);
INSERT INTO "MusicLabels" VALUES(2,'Parkwood Entertainment',2);
INSERT INTO "MusicLabels" VALUES(3,'Republic Records',5);
CREATE TABLE Songs (SongID INTEGER PRIMARY KEY, SongTitle TEXT, Duration INTEGER, AlbumID INTEGER, FOREIGN KEY(AlbumID) REFERENCES Albums(AlbumID));
INSERT INTO "Songs" VALUES(1,'Hello',306,1);
INSERT INTO "Songs" VALUES(2,'Formation',224,2);
INSERT INTO "Songs" VALUES(3,'Stronger',214,2);
INSERT INTO "Songs" VALUES(4,'All of Me',215,3);
INSERT INTO "Songs" VALUES(5,'Can You Feel the Love Tonight',182,4);
CREATE TABLE Tickets (TicketID INTEGER PRIMARY KEY, Quantity INTEGER, Price DECIMAL(10,2), ConcertID INTEGER, FOREIGN KEY(ConcertID) REFERENCES Concerts(ConcertID));
INSERT INTO "Tickets" VALUES(1,5000,100,1);
INSERT INTO "Tickets" VALUES(2,4000,80,1);
INSERT INTO "Tickets" VALUES(3,3000,70,2);
INSERT INTO "Tickets" VALUES(4,2000,60,3);
INSERT INTO "Tickets" VALUES(5,1000,50,5);
COMMIT;
