BEGIN TRANSACTION;
CREATE TABLE Accounts (AccountNumber INTEGER PRIMARY KEY, CustomerID INTEGER, Balance REAL, FOREIGN KEY(CustomerID) REFERENCES Customers(CustomerID));
INSERT INTO "Accounts" VALUES(10001,1,800.0);
INSERT INTO "Accounts" VALUES(10002,2,1000.0);
INSERT INTO "Accounts" VALUES(10003,3,900.0);
INSERT INTO "Accounts" VALUES(10004,4,700.0);
INSERT INTO "Accounts" VALUES(10005,5,600.0);
CREATE TABLE CheckingAccounts (CheckingID INTEGER PRIMARY KEY, Maximum_Deposit_Amount REAL, Monthly_Cap REAL, Checking_Account BOOLEAN , CustomerID INTEGER, FOREIGN KEY(CustomerID) REFERENCES Customers(CustomerID));
INSERT INTO "CheckingAccounts" VALUES(1,5000.0,800.0,1,1);
INSERT INTO "CheckingAccounts" VALUES(2,4000.0,1000.0,1,2);
INSERT INTO "CheckingAccounts" VALUES(3,3000.0,600.0,0,3);
INSERT INTO "CheckingAccounts" VALUES(4,2000.0,400.0,0,4);
INSERT INTO "CheckingAccounts" VALUES(5,1000.0,200.0,0,5);
CREATE TABLE Customers (CustomerID INTEGER PRIMARY KEY, fullname TEXT);
INSERT INTO "Customers" VALUES(1,'John Doe');
INSERT INTO "Customers" VALUES(2,'Jane Smith');
INSERT INTO "Customers" VALUES(3,'Michael Brown');
INSERT INTO "Customers" VALUES(4,'Emily White');
INSERT INTO "Customers" VALUES(5,'David Black');
CREATE TABLE Loans (LoanNumber INTEGER PRIMARY KEY, CustomerID INTEGER, Principal AMOUNT, InterestRate DECIMAL, MonthlyPayment REAL, FOREIGN KEY(CustomerID) REFERENCES Customers(CustomerID));
INSERT INTO "Loans" VALUES(1,1,10000,0.05,200.0);
INSERT INTO "Loans" VALUES(2,2,8000,0.06,160.0);
INSERT INTO "Loans" VALUES(3,3,9000,0.055,190.0);
INSERT INTO "Loans" VALUES(4,4,7000,0.055,140.0);
INSERT INTO "Loans" VALUES(5,5,6000,0.06,120.0);
CREATE TABLE SavingsAccounts (SavingsID INTEGER PRIMARY KEY, CustomerID INTEGER, InterestRate DECIMAL, FOREIGN KEY(CustomerID) REFERENCES Customers(CustomerID));
INSERT INTO "SavingsAccounts" VALUES(1,1,0.01);
INSERT INTO "SavingsAccounts" VALUES(2,2,0.02);
INSERT INTO "SavingsAccounts" VALUES(3,3,0.025);
INSERT INTO "SavingsAccounts" VALUES(4,4,0.03);
INSERT INTO "SavingsAccounts" VALUES(5,5,0.035);
CREATE TABLE Transactions (TransactionID INTEGER PRIMARY KEY, AccountNumber INTEGER, Amount REAL, TransactionDate DATETIME DEFAULT CURRENT_TIMESTAMP, FOREIGN KEY(AccountNumber) REFERENCES Accounts(AccountNumber));
INSERT INTO "Transactions" VALUES(1,10001,50.0,'2024-02-19 15:07:58');
INSERT INTO "Transactions" VALUES(2,10002,40.0,'2024-02-19 15:07:58');
INSERT INTO "Transactions" VALUES(3,10003,30.0,'2024-02-19 15:07:58');
INSERT INTO "Transactions" VALUES(4,10004,20.0,'2024-02-19 15:07:58');
INSERT INTO "Transactions" VALUES(5,10005,10.0,'2024-02-19 15:07:58');
COMMIT;
