BEGIN TRANSACTION;
CREATE TABLE Accounts (AccountNumber INTEGER PRIMARY KEY, CustomerID INTEGER, Balance DECIMAL(10,2), InterestRate DECIMAL(5,2), FOREIGN KEY(CustomerID) REFERENCES Customers(CustomerID));
INSERT INTO "Accounts" VALUES(1001,1,1000,2);
INSERT INTO "Accounts" VALUES(1002,2,8000,3);
INSERT INTO "Accounts" VALUES(1003,3,5000,2.5);
INSERT INTO "Accounts" VALUES(1004,4,7000,3.5);
INSERT INTO "Accounts" VALUES(1005,5,9000,3);
CREATE TABLE Addresses (AddressID INTEGER PRIMARY KEY, CustomerID INTEGER, City TEXT, Country TEXT, Banks TEXT, FOREIGN KEY(CustomerID) REFERENCES Customers(CustomerID));
INSERT INTO "Addresses" VALUES(1,1,'New York','USA','Chase');
INSERT INTO "Addresses" VALUES(2,2,'Los Angeles','USA','Bank of America');
INSERT INTO "Addresses" VALUES(3,3,'Chicago','USA','Wells Fargo');
INSERT INTO "Addresses" VALUES(4,4,'Houston','USA','Capital One');
INSERT INTO "Addresses" VALUES(5,5,'Phoenix','USA','US Bank');
CREATE TABLE Customers (CustomerID INTEGER PRIMARY KEY, fullname TEXT);
INSERT INTO "Customers" VALUES(1,'John Doe');
INSERT INTO "Customers" VALUES(2,'Jane Smith');
INSERT INTO "Customers" VALUES(3,'Michael Johnson');
INSERT INTO "Customers" VALUES(4,'Emily Williams');
INSERT INTO "Customers" VALUES(5,'David Brown');
CREATE TABLE Transactions (TransactionID INTEGER PRIMARY KEY, AccountNumber INTEGER, Amount DECIMAL(10,2), TransactionDate DATETIME DEFAULT CURRENT_TIMESTAMP, FOREIGN KEY(AccountNumber) REFERENCES Accounts(AccountNumber));
INSERT INTO "Transactions" VALUES(1,1001,500,'2021-01-01 10:00:00');
INSERT INTO "Transactions" VALUES(2,1002,1000,'2021-01-02 10:00:00');
INSERT INTO "Transactions" VALUES(3,1003,600,'2021-01-03 10:00:00');
INSERT INTO "Transactions" VALUES(4,1004,800,'2021-01-04 10:00:00');
INSERT INTO "Transactions" VALUES(5,1005,1100,'2021-01-05 10:00:00');
COMMIT;
