BEGIN TRANSACTION;
CREATE TABLE AccountTypes(AccountTypeID INTEGER PRIMARY KEY AUTOINCREMENT, TypeName TEXT);
INSERT INTO "AccountTypes" VALUES(1,'Checking');
INSERT INTO "AccountTypes" VALUES(2,'Savings');
INSERT INTO "AccountTypes" VALUES(3,'Money Market');
INSERT INTO "AccountTypes" VALUES(4,'CD');
INSERT INTO "AccountTypes" VALUES(5,'IRA');
CREATE TABLE Accounts(AccountNumber INTEGER PRIMARY KEY, InterestRate REAL, Balance REAL, OpenDate DATE, ForeignExchange FLOAT, Currency TEXT, AccountTypeId INTEGER, FOREIGN KEY(AccountTypeId) REFERENCES AccountTypes(AccountTypeId));
INSERT INTO "Accounts" VALUES(1,0.1,10000.0,'2021-01-01',1.1,'USD',1);
INSERT INTO "Accounts" VALUES(2,0.2,5000.0,'2021-02-01',1.2,'EUR',2);
INSERT INTO "Accounts" VALUES(3,0.3,8000.0,'2021-03-01',1.3,'GBP',3);
INSERT INTO "Accounts" VALUES(4,0.4,7000.0,'2021-04-01',1.4,'JPY',4);
INSERT INTO "Accounts" VALUES(5,0.5,6000.0,'2021-05-01',1.5,'CAD',5);
CREATE TABLE Clients(ClientID INTEGER PRIMARY KEY AUTOINCREMENT, ClientName TEXT, ContactEmail TEXT UNIQUE);
INSERT INTO "Clients" VALUES(1,'John Doe','johndoe@example.com');
INSERT INTO "Clients" VALUES(2,'Jane Smith','janesmith@example.com');
INSERT INTO "Clients" VALUES(3,'Alice Brown','alicebrown@example.com');
INSERT INTO "Clients" VALUES(4,'Bob White','bobwhite@example.com');
INSERT INTO "Clients" VALUES(5,'Charlie Green','charliegreen@example.com');
CREATE TABLE Investments(InvestmentID INTEGER PRIMARY KEY AUTOINCREMENT, PurchaseAmount REAL, DateOfPurchase DATE, ClientId INTEGER, AccountNumber INTEGER, FundStructure TEXT, MarketShare TEXT, FOREIGN KEY(ClientId) REFERENCES Clients(ClientID), FOREIGN KEY(AccountNumber) REFERENCES Accounts(AccountNumber));
INSERT INTO "Investments" VALUES(1,1000.0,'2021-01-01',1,1001,'Hedge Fund','2%');
INSERT INTO "Investments" VALUES(2,2000.0,'2021-02-01',2,2001,'Hedge Fund','5%');
INSERT INTO "Investments" VALUES(3,1500.0,'2021-03-01',3,3001,'Mutual Fund','2%');
INSERT INTO "Investments" VALUES(4,3000.0,'2021-04-01',4,4001,'Mutual Fund','4%');
INSERT INTO "Investments" VALUES(5,5000.0,'2021-05-01',5,5001,'Index Fund','6%');
DELETE FROM "sqlite_sequence";
INSERT INTO "sqlite_sequence" VALUES('Clients',5);
INSERT INTO "sqlite_sequence" VALUES('AccountTypes',5);
INSERT INTO "sqlite_sequence" VALUES('Investments',5);
COMMIT;
