BEGIN TRANSACTION;
CREATE TABLE Appointments (AppointmentID INTEGER PRIMARY KEY, PatientID INTEGER, DoctorID INTEGER, DateAndTime TIMESTAMP, FOREIGN KEY(PatientID) REFERENCES Patients(PatientID), FOREIGN KEY(DoctorID) REFERENCES Doctors(DoctorID));
INSERT INTO "Appointments" VALUES(1,1,1,'2023-01-10 14:00:00');
INSERT INTO "Appointments" VALUES(2,2,2,'2023-02-12 10:00:00');
INSERT INTO "Appointments" VALUES(3,3,3,'2023-03-15 16:00:00');
INSERT INTO "Appointments" VALUES(4,4,4,'2023-04-05 11:00:00');
INSERT INTO "Appointments" VALUES(5,5,5,'2023-05-10 09:00:00');
CREATE TABLE "Conditions" (ConditionID INTEGER PRIMARY KEY, Symptom_Relief TEXT, Medication TEXT, Severity TEXT);
INSERT INTO "Conditions" VALUES(1,'Hypertension','Lisinopril','Moderate');
INSERT INTO "Conditions" VALUES(2,'Epilepsy','Lamotrigine','Mild');
INSERT INTO "Conditions" VALUES(3,'Asthma','Fluticasone','Mild');
INSERT INTO "Conditions" VALUES(4,'Inflammatory Bowel Disease','Prednisone','Moderate');
INSERT INTO "Conditions" VALUES(5,'Osteoarthritis','Acetaminophen','Mild');
CREATE TABLE Diagnoses (DiagnosisID INTEGER PRIMARY KEY, PatientID INTEGER, ConditionID INTEGER, DateOfDiagnosis DATE, FOREIGN KEY(PatientID) REFERENCES Patients(PatientID), FOREIGN KEY(ConditionID) REFERENCES Conditions(ConditionID));
INSERT INTO "Diagnoses" VALUES(1,1,1,'2022-12-01');
INSERT INTO "Diagnoses" VALUES(2,2,2,'2022-12-15');
INSERT INTO "Diagnoses" VALUES(3,3,3,'2023-01-05');
INSERT INTO "Diagnoses" VALUES(4,4,4,'2023-02-20');
INSERT INTO "Diagnoses" VALUES(5,5,5,'2023-03-05');
CREATE TABLE Doctors (DoctorID INTEGER PRIMARY KEY, DoctorName TEXT, Specialty TEXT);
INSERT INTO "Doctors" VALUES(1,'Dr. Brown','Cardiology');
INSERT INTO "Doctors" VALUES(2,'Dr. Green','Neurology');
INSERT INTO "Doctors" VALUES(3,'Dr. White','Pulmonology');
INSERT INTO "Doctors" VALUES(4,'Dr. Black','Gastroenterology');
INSERT INTO "Doctors" VALUES(5,'Dr. Gray','Orthopedics');
CREATE TABLE Patients (PatientID INTEGER PRIMARY KEY, FirstName TEXT, LastName TEXT, DateOfBirth DATE);
INSERT INTO "Patients" VALUES(1,'John','Doe','2000-01-01');
INSERT INTO "Patients" VALUES(2,'Jane','Smith','1987-06-15');
INSERT INTO "Patients" VALUES(3,'Michael','Johnson','1993-11-23');
INSERT INTO "Patients" VALUES(4,'Emily','Williams','1995-09-08');
INSERT INTO "Patients" VALUES(5,'David','Martinez','1981-02-12');
CREATE TABLE Prescriptions (PrescriptionID INTEGER PRIMARY KEY, AppointmentID INTEGER, Medication TEXT, Quantity INTEGER, Instructions TEXT, FOREIGN KEY(AppointmentID) REFERENCES Appointments(AppointmentID));
INSERT INTO "Prescriptions" VALUES(1,1,'Lisinopril',30,'Take once daily.');
INSERT INTO "Prescriptions" VALUES(2,2,'Lamotrigine',60,'Take twice daily with food.');
INSERT INTO "Prescriptions" VALUES(3,3,'Fluticasone',30,'Use inhaler as directed by your doctor.');
INSERT INTO "Prescriptions" VALUES(4,4,'Prednisone',10,'Take as prescribed by your doctor.');
INSERT INTO "Prescriptions" VALUES(5,5,'Acetaminophen',30,'Take every 6 hours if needed.');
COMMIT;
