BEGIN TRANSACTION;
CREATE TABLE AgeGroupPopulations (AgeGroupID INTEGER REFERENCES AgeGroups(ID), Year INTEGER REFERENCES BirthYears(Year), CityName TEXT REFERENCES Cities(CityName), TotalPopulation INTEGER);
INSERT INTO "AgeGroupPopulations" VALUES(1,2018,'New York',100000);
INSERT INTO "AgeGroupPopulations" VALUES(1,2018,'Los Angeles',80000);
INSERT INTO "AgeGroupPopulations" VALUES(1,2018,'Chicago',70000);
INSERT INTO "AgeGroupPopulations" VALUES(1,2018,'Houston',60000);
INSERT INTO "AgeGroupPopulations" VALUES(1,2018,'Phoenix',50000);
CREATE TABLE AgeGroups (ID INTEGER PRIMARY KEY, Name TEXT);
INSERT INTO "AgeGroups" VALUES(1,'0-9');
INSERT INTO "AgeGroups" VALUES(2,'10-19');
INSERT INTO "AgeGroups" VALUES(3,'20-29');
INSERT INTO "AgeGroups" VALUES(4,'30-39');
INSERT INTO "AgeGroups" VALUES(5,'40-49');
CREATE TABLE "BirthYears" (Year INTEGER PRIMARY KEY, Birth_Rate INTEGER, City TEXT);
INSERT INTO "BirthYears" VALUES(2018,1000,'New York');
INSERT INTO "BirthYears" VALUES(2019,1050,'Los Angeles');
INSERT INTO "BirthYears" VALUES(2020,1100,'Chicago');
INSERT INTO "BirthYears" VALUES(2021,1150,'Houston');
INSERT INTO "BirthYears" VALUES(2022,1200,'Phoenix');
CREATE TABLE Cities (CityName TEXT PRIMARY KEY, RegionName TEXT REFERENCES Regions(RegionName));
INSERT INTO "Cities" VALUES('New York','Northeast');
INSERT INTO "Cities" VALUES('Los Angeles','West');
INSERT INTO "Cities" VALUES('Chicago','Midwest');
INSERT INTO "Cities" VALUES('Houston','South');
INSERT INTO "Cities" VALUES('Phoenix','West');
CREATE TABLE CityEducationStats (CityName TEXT REFERENCES Cities(CityName), Level TEXT REFERENCES EducationLevels(Level), Percentage INTEGER , FOREIGN KEY (CityName) REFERENCES Cities(CityName));
INSERT INTO "CityEducationStats" VALUES('New York','High School Diploma',27);
INSERT INTO "CityEducationStats" VALUES('Los Angeles','Some College',32);
INSERT INTO "CityEducationStats" VALUES('Chicago','Associate Degree',11);
INSERT INTO "CityEducationStats" VALUES('Houston','Bachelor''s Degree',36);
INSERT INTO "CityEducationStats" VALUES('Phoenix','Graduate Degree',16);
CREATE TABLE EducationLevels (Level TEXT PRIMARY KEY, Percentage INTEGER );
INSERT INTO "EducationLevels" VALUES('High School Diploma',25);
INSERT INTO "EducationLevels" VALUES('Some College',30);
INSERT INTO "EducationLevels" VALUES('Associate Degree',10);
INSERT INTO "EducationLevels" VALUES('Bachelor''s Degree',35);
INSERT INTO "EducationLevels" VALUES('Graduate Degree',15);
CREATE TABLE Regions (RegionName TEXT PRIMARY KEY, PopulationCount INTEGER);
INSERT INTO "Regions" VALUES('Northeast',2000000);
INSERT INTO "Regions" VALUES('Midwest',1500000);
INSERT INTO "Regions" VALUES('South',1000000);
INSERT INTO "Regions" VALUES('West',1200000);
INSERT INTO "Regions" VALUES('Other',500000);
COMMIT;
