import os

def set_directory(args, prompt):
    output_dir = f"results/zeroscope_fifo/random_noise/{prompt}"

    if args.eta != 0.0:
        output_dir += f"/eta{args.eta}"
    if args.new_video_length != 100:
        output_dir += f"/{args.new_video_length}frames"
    if args.lookahead_denoising:
        output_dir = output_dir.replace(f"{prompt}", f"{prompt}/lookahead_denoising")
    if args.num_partitions != 1:
        output_dir = output_dir.replace(f"{prompt}", f"{prompt}/{args.num_partitions}partitions")
    if args.video_length != 24:
        output_dir = output_dir.replace(f"{prompt}", f"{prompt}/{args.video_length}frames")

    latents_dir = f"results/zeroscope_fifo/latents/{args.num_inference_steps}steps/{prompt}"

    print("The results will be saved in", output_dir)
    print("The latents will be saved in", latents_dir)

    return output_dir, latents_dir