from .tool_interface import BaseToolkit

__TOOLKITS_DICT__ = {}


def get_toolkit_dict():
    return __TOOLKITS_DICT__


def toolkits_factory(name):
    return __TOOLKITS_DICT__.get(name, None)


def register_toolkit(overwrite=None):
    def register_function_fn(cls):
        name = overwrite
        if name is None:
            name = cls.__name__
        if name in __TOOLKITS_DICT__:
            raise ValueError(f"Name {name} already registered!")
        if not issubclass(cls, BaseToolkit):
            raise ValueError(f"Class {cls} is not a subclass of {BaseToolkit}")
        __TOOLKITS_DICT__[name] = cls
        # print(f"Toolkit registered: [{name}]")
        return cls

    return register_function_fn
