# Model-Based Zero-Shot Transfer in Deep Reinforcement Learning

## Directory

```
MBTL/
├── analysis/
│   ├── collect_result.py       # Script to collect and process results of MBTL algorithms and all baselines
│   └── utils.py                # Utility functions for analysis
├── advisory-autonomy/
│   ├── pexps/                  # Code for experiments
│   ├── u/                      # Utils
│   └── s-*.sh                  # job script file
├── eco-driving/
│   ├── code/                   # Code for experiments
│   ├── datasets/               # Datasets for the eco-driving task
│   ├── misc/                   # Miscellaneous files
│       └── idm_calibrations/   # Calibrations for the Intelligent Driver Model
│   ├── requirements.txt.       # Python requirements file
│   └── s-*.sh                  # job script file
└── traffic-signal/
    ├── network/                # Code related to traffic network
    ├── settings/               # Settings and configurations
    ├── environment.yml         # Environment file for managing dependencies
    ├── generator.py            # Script for generating traffic scenarios
    ├── model.py                # Code for the RL algorithm
    ├── testing_main.py         # Main script for testing
    ├── testing_simulation.py   # Simulation code for testing
    ├── training_main.py        # Main script for training
    ├── training_simulation.py  # Simulation code for training
    ├── transfer_main.py        # Main script for transfer learning
    ├── transfer_simulation.py  # Simulation code for transfer learning
    ├── utils.py                # Utility functions
    └── script-*.sh             # job script file
```

## Installation

```
pip install -r requirements.txt
```
