# Instruction Embedding: Latent Representations of Instructions Towards Task Identification

This is the introduction to code for **Instruction Embedding: Latent Representations of Instructions Towards Task Identification**.

## Benchmark Data

Please download the wiki1m_for_simcse.json following the instruction in https://github.com/princeton-nlp/SimCSE (data/download_wiki.sh) and put the dataset into `instruction-embedding-benchmark/data`.

The benchmark is located in `instruction-embedding-benchmark/data`

.
├── eft_test.json
├── eft_train_sup.json
├── eft_train_unsup.json
├── full_ieb_data.json
├── ift_test.json
├── ift_test_alpaca_style.json
├── ift_train.json
├── ift_train_alpaca_style.json
├── intention_similarity_test.json
└── wiki1m_for_simcse.json

`full_ieb_data.json` is the unspilted benchmark data, which contains 47,161 samples of 1,353 tasks.

`eft_train_sup.json` and `ift_train.json` are supervised instruction embedding train set and instruction tuning train set separately. As for `eft_test.json` and `ift_test.json` are the corresponding test sets.

`eft_train_unsup.json` is the unsupervised version of `eft_train_sup.json` which is used to train unsupervised baselines, and `wiki1m_for_simcse.json` is the Wiki train data from SimCSE.

`ift_test_alpaca_style.json` and `ift_train_alpaca_style.json` transfer the raw dict style into list style which is aligned with alpaca dataset.

## Download datasets for correlation analysis

Download the datasets with the corresponding links and put them into `instruction-embedding-benchmark/correlation_analysis/dataset`.

GSM8K https://huggingface.co/datasets/openai/gsm8k
MATH https://github.com/hendrycks/math
MBPP https://huggingface.co/datasets/google-research-datasets/mbpp
Lima https://huggingface.co/datasets/GAIR/lima
Dolly https://huggingface.co/datasets/databricks/databricks-dolly-15k
OAssit https://huggingface.co/datasets/OpenAssistant/oasst1
Alpaca https://huggingface.co/datasets/yahma/alpaca-cleaned
WizardLM(Alpaca) https://huggingface.co/datasets/cognitivecomputations/WizardLM_alpaca_evol_instruct_70k_unfiltered

WizardLM(ShareGPT) https://huggingface.co/datasets/WizardLMTeam/WizardLM_evol_instruct_V2_196k

ShareGPT https://huggingface.co/datasets/anon8231489123/ShareGPT_Vicuna_unfiltered

## Run Code

The code running scrips can be found in `instruction-embedding-benchmark/scripts`.

.
├── baseline.sh
└── full_pipeline.sh

The `baseline.sh` and `full_pipeline.sh` all includes the launch scripts of `embedding model training`, `dataset encoding`, `intention similarity test (IIS)`, `embedding clustering test`, `demonstration selection and infer with demonstrations` and `data selection`.

To conduct the dataset correlation analysis, you should first encode datasets in `instruction-embedding-benchmark/correlation_analysis/dataset` and store the embeddings in the same directory. Then launch `instruction-embedding-benchmark/correlation_analysis/run.sh` in the `instruction-embedding-benchmark/correlation_analysis` directory.

Before you lauch each scripts, you should assign the model paths and save paths which is set to 'path' at present.

And you should change `POOLING` from 'cls' to 'last-2' and comment out `--bert` option if you are running a llama model.

