# Introduction

This artifact contains the experiments for our NeurIPS'24 paper on Neural Model Checking [1]. The README provides details on the directory structure, installation guide, information about the setup used in the paper, and a step-by-step guide for reproducing the experiments using Docker.

Experiments involving industry tools are not included in this artifact due to their proprietary nature. All other experiments can be fully reproduced using the files below.

All the LICENSES for the dependencies are included in their websites which have been cited in this document. 

[1] Mirco Giacobbe, Daniel Kroening, Abhinandan Pal, and Michael Tautschnig (alphabetical). “Neural Model Checking”. Thirty-Eighth Annual Conference on Neural Information Processing Systems (NeurIPS’24), December 9-15, 2024, Vancouver, Canada.

# Directory Structure

The overall structure of this artifact is presented below.

```
.
├── README.md (you are here)
├── LICENSE
│
├── Benchmarks
│   └── [Design-name]_[number].sv 
│ 
├── NeurIPS_Experiments
│        ├── RunBenchmark
│        │     └── [Spec-number]_[Design-name].py
│        ├── lgc_cnt.py
│        └── paper_plots.py
│
└── Tools
    │
    ├── ABC-MC
    │    ├── abc_run.py
    │    ├── ltl2smv
    │    ├── simple_liveness.sh
    │    └── smvtoaig
    ├── nuXmv
    │   ├── nuxmv_run.py
    │   └── nuXmv
    │
    ├── EBMC
    │    └── ebmc
    │
    └── Neuralmc
         ├── Verilog-Sampler  
         ├── Traces
         ├── Model-SMT
         ├── Netlists  
         ├── nrf.py
         ├── nuR.py
         └── bitwuzlaEncoderBV.py     
    
```

The overview omits details (files and folders) that are not relevant to our paper.

# Content

## `Benchmarks/[Design-name]_[number].sv`

This folder contains 123 SystemVerilog files used in our experiments. `[Design-name]` refers to the name of the SystemVerilog file as mentioned in the main paper, and `[number]` orders the parameterizable designs by state space size.


## `NeurIPS_Experiments/RunBenchmark/[Spec-number]_[Design-name].py`

This folder contains Python scripts for running different tools on each `[Design-name]`. Some designs include more than one specification, with separate scripts for each. The specification is printed during execution or, alternatively, included within the script as `specTXT`.


## `NeurIPS_Experiments/RunBenchmark/lgc_cnt.py`

This script obtains the logic gate count for all files in the `Benchmarks/` directory using EBMC.


## `NeurIPS_Experiments/RunBenchmark/paper_plots.py`

This script generates various statistics and plots presented in the paper. Please note that the raw data is not computed at runtime but is hardcoded, as running all the experiments would take several days.


## `Tools/ABC-MC`

This folder contains the tools required to compare with the ABC model checker. `ltl2smv` [1] converts LTL specifications to SMV and is a dependency for `smvtoaig` [2], which converts `.smv` files to `.aig`—the file format ABC accepts. In addition to files distributed with the artefact, please build the Super Prove tool suite from source [3]. According to our experience this only works with Ubuntu Linux 16.04. Once built, copy over the `build/super_prove` subdirectory to the host that you actually run experiments on, install libpython2.7, and adjust the path in `Tools/ABC-MC/abc_run.py` of the `simple_liveness.sh` invocation to match your set-up.


## `Tools/nuXmv`

This folder contains the binary for nuXmv version 2.0.0 [4]. It also includes `Tools/nuXmv/nuxmv_run.py`, which is used by the scripts in `NeurIPS_Experiments/RunBenchmark/` to execute experiments on nuXmv.


## `Tools/EBMC`

This folder contains a binary for EBMC v5.2 [5,6].


## `Tools/Neuralmc/Verilog-Sampler`

This folder is used during execution to store SystemVerilog files with appended Constraint Random Verification (CRV) testbenches. The files are generated via a script and simulated using `verilator` to produce the training dataset.


## `Tools/Neuralmc/Traces`

This folder is used during execution to store execution traces generated by simulating the SystemVerilog files from `Tools/Neuralmc/Verilog-Sampler`. These traces will then be used as the training dataset.


## `Tools/Neuralmc/Model-SMT`

This folder is used during execution to store the SystemVerilog designs under verification as SMT, converted using EBMC, for Bitwuzla.


## `Tools/Neuralmc/Netlists`

This folder is used during execution to store the netlist of the hardware design, obtained using EBMC. The netlists provide the latch count of the design.


## `Tools/Neuralmc/bitwuzlaEncoderBV.py`
This script serves as an encoder that converts a PyTorch neural network into SMT format using `Bitwuzla`, or exports it to `SystemVerilog`.


## `Tools/Neuralmc/nrf.py`
Contains the definitions for the neural network architecture along with the scripts needed for training.


## `Tools/Neuralmc/nuR.py`
The main script nuR (Neural Reasoning) that orchestrates the execution of other scripts and manages dependencies.


[1] https://github.com/felipeblassioli/nusmv
[2] https://github.com/zimmski/aiger/
[3] https://github.com/sterin/super-prove-build
[4] https://nuxmv.fbk.eu/download.html
[5] http://www.cprover.org/ebmc/
[6] https://github.com/diffblue/hw-cbmc


# Installing Dependencies


The artifact itself contains most of the dependencies and their source have been referenced above. Besides those, the user must install `Verilator Version 5.02` and `Bitwuzla`.

To install Verilator, follow the instructions on their installation page [7]. In case `VERILATOR_ROOT` isn't set correctly, change `VERILATOR_ROOT` as described in their tutorial on Create-Binary Execution [8], which also demonstrates the Verilator commands that are used by us.

To install Bitwuzla, follow their installation and build instructions [9].

[7] https://verilator.org/guide/latest/install.html
[8] https://verilator.org/guide/latest/example_binary.html
[9] https://bitwuzla.github.io/docs/install.html

# Operating System and Hardware Requirements

To the best of our knowledge, this implementation of neural model checking should work on any modern hardware running a modern operating system, as long as our dependencies are built for that configuration. The binaries provided for our dependencies in this artefact are for **Ubuntu 20.04** running on an **Intel CPU**.

We use **Ubuntu 20.04** because the authors of ABC have informed us that, "because of the Python 2.X to Python 3.X incompatibility, a slightly older version of Linux, such as Ubuntu 18.04 or maybe 20.04 is preferred." We ended up having to go back as far as Ubuntu 16.04 _to build_ ABC, but then copied over the resulting build artefacts and ran all experiments on Ubuntu 20.04.

For ABC, installation on **Ubuntu 16.04**, in addition to following their build intructions [3] it is  necessary to run `apt install zlib1g-dev`. Although all tools are built for Ubuntu and our experiments were primarily conducted on **Intel CPUs**, we did a basic compatibility test on an **M2 MacBook Air** with Docker running **Ubuntu 20.04**. All tools except ABC ran successfully. ABC didn't work even on **Ubuntu 18.04**. Readers should be able to reproduce all experiments except ABC on a **MacBook** with an **ARM chip**. We emphasize all our reported experiments were performed on **Intel CPUs**.

We don't have any specific hardware requirements, and our neural network is trained on a CPU by default.

# Docker Setup

Run a Ubuntu:20.04 docker, with a shared volume containing the Artefact

```shell
docker run -it --rm --volume ./NeurIPS-Artefact:/NeurIPS-Artefact ubuntu:20.04
```

Install python3
```shell
apt update
apt upgrade
apt install python3
apt install pip
apt install software-properties-common
```

Install the Python Dependencies:

```shell
pip install colorama
pip install torch
pip install pandas
pip install torch_optimizer
```

Install Verilator:
```shell
# Prerequisites:
# apt install git help2man perl python3 make autoconf g++ flex bison ccache
# apt install libgoogle-perftools-dev numactl perl-doc
# apt install libfl2  # Ubuntu only (ignore if gives error)
# apt install libfl-dev  # Ubuntu only (ignore if gives error)
# apt install zlibc zlib1g zlib1g-dev  # Ubuntu only (ignore if gives error)

git clone https://github.com/verilator/verilator   # Only first time

# Every time you need to build:
unsetenv VERILATOR_ROOT  # For csh; ignore error if on bash
unset VERILATOR_ROOT  # For bash
cd verilator
git pull         # Make sure git repository is up-to-date
git tag          # See what versions exist
#git checkout master      # Use development branch (e.g. recent bug fixes)
#git checkout stable      # Use most recent stable release
#git checkout v{version}  # Switch to specified release version
git checkout v5.022

autoconf         # Create ./configure script
./configure      # Configure and create Makefile
make -j `nproc`  # Build Verilator itself (if error, try just 'make')
make install
```

Test if verilator is installed correctly,
```shell
mkdir test_our
cd test_our

cat >our.v <<'EOF'
  module our;
     initial begin $display("Hello World"); $finish; end
  endmodule
EOF

verilator --binary -j 0 -Wall our.v
```


Install Bitwuzla Python Binding (Make sure to do this after Verilator, as there are common Prerequisites):
```shell
# Additional Prerequisites:
pip install cmake meson ninja cython

# Clone Bitwuzla repository
git clone https://github.com/bitwuzla/bitwuzla
cd bitwuzla

# Build and install Bitwuzla Python bindings
pip install .
```


# Run Experiment for 1 DUT-Spec pair

Running all experiments sequentially with a script would require days. We recommend reproducing the experiments for all variants of one of the designs. We suggest starting with the `Delay` DUT (Device Under Test) using the specification `F G !rst -> G F sig` due to its simplicity. Feel free to try a different design-specification pair first; the guide will be identical for all pairs.

Navigate to the directory containing the Python scripts:

```shell
root@299d409623c1:/# cd NeurIPS'24_Experiments/Benchmark_Run/
```

Use `ls` to check the list of available scripts. We recommend running `1_delay.py` as the first script. These scripts will run all experiments for a DUT-specification pair using the tool selected by the user.

```shell
root@299d409623c1:/NeurIPS'24_Experiments/Benchmark_Run# python3 1_delay.py 
1)ABC 2)nuXmv 3)our
Enter your choice: 
```
Choice 1 ABC

```shell
1)ABC 2)nuXmv 3)our
Enter your choice: 1
delay_1 (F G !rst -> G F sig) 750
! ( F G ( Verilog.DELAY.rst <-> 0  ) -> G F ( Verilog.DELAY.sig <-> 1  )  )


ABC LIVE evaluating delay_1.aig

0
j0
.


ABC LIVE TIME: 403.44078540802
```

Choice 2 nuXmv

```shell
1)ABC 2)nuXmv 3)our
Enter your choice: 2
delay_1 (F G !rst -> G F sig) 750
*** This is nuXmv 2.0.0 (compiled on Mon Oct 14 17:48:12 2019)
*** Copyright (c) 2014-2019, Fondazione Bruno Kessler
*** For more information on nuXmv see https://nuxmv.fbk.eu
*** or email to <nuxmv@list.fbk.eu>.
*** Please report bugs at https://nuxmv.fbk.eu/bugs
*** (click on "Login Anonymously" to access)
*** Alternatively write to <nuxmv@list.fbk.eu>.

*** This version of nuXmv is linked to NuSMV 2.6.0.
*** For more information on NuSMV see <http://nusmv.fbk.eu>
*** or email to <nusmv-users@list.fbk.eu>.
*** Copyright (C) 2010-2019, Fondazione Bruno Kessler

*** This version of nuXmv is linked to the CUDD library version 2.4.1
*** Copyright (c) 1995-2004, Regents of the University of Colorado

*** This version of nuXmv is linked to the MiniSat SAT solver. 
*** See http://minisat.se/MiniSat.html
*** Copyright (c) 2003-2006, Niklas Een, Niklas Sorensson
*** Copyright (c) 2007-2010, Niklas Sorensson

*** This version of nuXmv is linked to MathSAT
*** Copyright (C) 2009-2019 by Fondazione Bruno Kessler
*** Copyright (C) 2009-2019 by University of Trento and others
*** See http://mathsat.fbk.eu

-- specification ( F ( G Verilog.DELAY.rst = FALSE) ->  G ( F Verilog.DELAY.sig = TRUE))  is true


nuXmv TIME: 1.2782557010650635
```
Choice 3 Our:

**Ensure that `network_type` is set to `A3-Default` and `SMTencode` is set to `new`, otherwise one of the Ablation Studies will be executed, which may lead to suboptimal results.**


The output from our tool includes:

- **Printed DUT name and specification**, along with all hyperparameters, including those used for ablation studies.

- **Short SMT sanity check result** (this should be `sat`).

- **Compilation information** of the SystemVerilog design using Verilator for sampling.

- **Loss recorded every 10th epoch** during the training of the neural network.

- **Transition outputs (`T->x`)**: These represent three transitions to `q = x` in the specification automaton. If `q = x` is a fair state, the neural network's output values decrease by at least 0.01, as shown in `T->1` (e.g., from `-12.55` to `-12.565`). If `q = x` is not a fair state, the output value should not increase, as in the case of `T->0`, where every output remains at `0.576`.

- **State Range outputs (`Qx`)**: Represents the minimum and maximum range of outputs for all states where the automaton state `q = x`. For example, for `q = 0`, the network always returns `0.576`, and for `q = 1`, it outputs values between `-15.29` and `-4.05`.

- **The trained neural network architecture**.

- **Time taken** to SMT-check each condition, along with the total time.

```shell
1)ABC 2)nuXmv 3)our
Enter your choice: 3
                 delay_1 (F G !rst -> G F sig) 750
                 (0.1, 2, 50, A3-Default, new, (100000, 50), 7)
Parsing ../../Benchmarks/delay_1.sv
Converting
Type-checking Verilog::DELAY
Generating Decision Problem
Writing SMT2 formula to `../../Tools/neuralmc/Model-SMT/delay_1.smt2'
Properties
sat
((|Verilog::DELAY.cnt@0| #b0000000000))
((|Verilog::DELAY.cnt@1| #b0000000001))
((|Verilog::DELAY.cnt_aux0@0| #b0000000001))
((|Verilog::DELAY.err@1| false))
((|Verilog::DELAY.flg@1| true))
((|Verilog::DELAY.rst@0| false))
((|Verilog::DELAY.sig@1| false))
Time Range Invar: 0.0003294944763183594
Range is an Invar [PASS]
make: Entering directory '/neuralmcY2/NeurIPS'24_Experiments/Benchmark_Run/obj_dir'
ccache g++ -Os  -I.  -MMD -I/usr/local/share/verilator/include -I/usr/local/share/verilator/include/vltstd -DVM_COVERAGE=0 -DVM_SC=0 -DVM_TRACE=0 -DVM_TRACE_FST=0 -DVM_TRACE_VCD=0 -faligned-new -fcf-protection=none -Wno-bool-operation -Wno-shadow -Wno-sign-compare -Wno-tautological-compare -Wno-uninitialized -Wno-unused-but-set-parameter -Wno-unused-but-set-variable -Wno-unused-parameter -Wno-unused-variable    -DVL_TIME_CONTEXT   -fcoroutines -c -o verilated.o /usr/local/share/verilator/include/verilated.cpp
ccache g++ -Os  -I.  -MMD -I/usr/local/share/verilator/include -I/usr/local/share/verilator/include/vltstd -DVM_COVERAGE=0 -DVM_SC=0 -DVM_TRACE=0 -DVM_TRACE_FST=0 -DVM_TRACE_VCD=0 -faligned-new -fcf-protection=none -Wno-bool-operation -Wno-shadow -Wno-sign-compare -Wno-tautological-compare -Wno-uninitialized -Wno-unused-but-set-parameter -Wno-unused-but-set-variable -Wno-unused-parameter -Wno-unused-variable    -DVL_TIME_CONTEXT   -fcoroutines -c -o verilated_timing.o /usr/local/share/verilator/include/verilated_timing.cpp
ccache g++ -Os  -I.  -MMD -I/usr/local/share/verilator/include -I/usr/local/share/verilator/include/vltstd -DVM_COVERAGE=0 -DVM_SC=0 -DVM_TRACE=0 -DVM_TRACE_FST=0 -DVM_TRACE_VCD=0 -faligned-new -fcf-protection=none -Wno-bool-operation -Wno-shadow -Wno-sign-compare -Wno-tautological-compare -Wno-uninitialized -Wno-unused-but-set-parameter -Wno-unused-but-set-variable -Wno-unused-parameter -Wno-unused-variable    -DVL_TIME_CONTEXT   -fcoroutines -c -o verilated_threads.o /usr/local/share/verilator/include/verilated_threads.cpp
/usr/bin/python3 /usr/local/share/verilator/bin/verilator_includer -DVL_INCLUDE_OPT=include Vdelay_1_smp.cpp Vdelay_1_smp___024root__DepSet_h45ce7cb9__0.cpp Vdelay_1_smp___024root__DepSet_hefa1743f__0.cpp Vdelay_1_smp__main.cpp Vdelay_1_smp__ConstPool_0.cpp Vdelay_1_smp___024root__Slow.cpp Vdelay_1_smp___024root__DepSet_hefa1743f__0__Slow.cpp Vdelay_1_smp__Syms.cpp > Vdelay_1_smp__ALL.cpp
ccache g++ -Os  -I.  -MMD -I/usr/local/share/verilator/include -I/usr/local/share/verilator/include/vltstd -DVM_COVERAGE=0 -DVM_SC=0 -DVM_TRACE=0 -DVM_TRACE_FST=0 -DVM_TRACE_VCD=0 -faligned-new -fcf-protection=none -Wno-bool-operation -Wno-shadow -Wno-sign-compare -Wno-tautological-compare -Wno-uninitialized -Wno-unused-but-set-parameter -Wno-unused-but-set-variable -Wno-unused-parameter -Wno-unused-variable    -DVL_TIME_CONTEXT   -fcoroutines -c -o Vdelay_1_smp__ALL.o Vdelay_1_smp__ALL.cpp
echo "" > Vdelay_1_smp__ALL.verilator_deplist.tmp
Archive ar -rcs Vdelay_1_smp__ALL.a Vdelay_1_smp__ALL.o
g++    verilated.o verilated_timing.o verilated_threads.o Vdelay_1_smp__ALL.a    -pthread -lpthread -latomic   -o Vdelay_1_smp
rm Vdelay_1_smp__ALL.verilator_deplist.tmp
make: Leaving directory '/neuralmcY2/NeurIPS'24_Experiments/Benchmark_Run/obj_dir'
- V e r i l a t i o n   R e p o r t: Verilator 5.024 2024-04-05 rev v5.024-42-gc561fe8ba
- Verilator: Built from 0.013 MB sources in 3 modules, into 0.028 MB in 8 C++ files needing 0.000 MB
- Verilator: Walltime 0.196 s (elab=0.000, cvt=0.002, bld=0.190); cpu 0.000 s on 20 threads; alloced 57.758 MB
- ../../Tools/neuralmc/Verilog-Sampler/delay_1_smp.sv:66: Verilog $finish
- S i m u l a t i o n   R e p o r t: Verilator 5.024 2024-04-05
- Verilator: $finish at 6us; walltime 1.838 s; speed 0.000 s/s
- Verilator: cpu 0.000 s on 1 threads; alloced 152 MB
        ----------Training Data Generation Completed------------
    ------------DATASET SIZE = (ALL: {0: 1452, 1: 1500})------------
Process 2 started with colour 
 [2] loss before : 1.4816014766693115 --> 
            {'l0': 0.0008476870134472847, 'l1': 1.480753779411316} LRate: 0.1 
 [2] loss [0] : 1.4816014766693115 --> 
            {'l0': 0.0008476870134472847, 'l1': 1.480753779411316} LRate: 0.1 
 [2] loss [10] : 0.013296345248818398 --> 
            {'l0': 0.013296345248818398, 'l1': 0.0} LRate: 0.1 
 [2] loss [20] : 6.706604472128674e-05 --> 
            {'l0': 6.706604472128674e-05, 'l1': 0.0} LRate: 0.1 
 [2] loss [30] : 7.077727059368044e-05 --> 
            {'l0': 7.077727059368044e-05, 'l1': 0.0} LRate: 0.1 
 [2] loss [40] : 0.0026949855964630842 --> 
            {'l0': 0.0026949855964630842, 'l1': 0.0} LRate: 0.1 
 [2] loss [42] : 0.0 --> 
            {'l0': 0.0, 'l1': 0.0}  LRate: 0.1 
 T->0: False [0.5764337182044983, 0.5764337182044983, 0.5764337182044983] ---> [0.5764337182044983, 0.5764337182044983, 0.5764337182044983]
 T->1: True [-12.549884796142578, 0.5764337182044983, -6.380736351013184] ---> [-12.565003395080566, -6.380736351013184, -6.396030902862549]
 Q0: (0.5764337182044983, 0.5764337182044983)
 Q1: (-15.291332244873047, -4.052342414855957)
ACCEPT -> [1]
NOT ACCEPT -> [0]
 [2] Time VERIFY 1: 9.90813422203064
 [2] Condition 1 [PASS]
 [2] Time VERIFY 2: 13.71400785446167
 [2] Condition 2 [PASS]
Yay!!! We have a Ranking function
Result from the first finishing process: {0: NRF_Clamp(
  (fc_1): Linear(in_features=2, out_features=8, bias=True)
  (fc_2): Linear(in_features=8, out_features=5, bias=True)
  (fc_3): Linear(in_features=5, out_features=1, bias=True)
), 1: NRF_Clamp(
  (fc_1): Linear(in_features=2, out_features=8, bias=True)
  (fc_2): Linear(in_features=8, out_features=5, bias=True)
  (fc_3): Linear(in_features=5, out_features=1, bias=True)
)}
Process 2 Ended.
BITS ---------->>>>>>>>> 27 delay_1 (F G !rst -> G F sig) 750
Clamp ---------->>>>>>>>> 7
Total Time: 16.778693199157715
```


# Run All Main Experiments

To obtain All main experiments follow the **Run Experiment for 1 DUT-Spec pair** guide for all python scripts in `/NeurIPS'24_Experiments/Benchmark_Run`

**Ensure that `network_type` is set to `A3-Default` and `SMTencode` is set to `new` in all the scripts, otherwise one of the Ablation Studies will be executed, which may lead to suboptimal results.**


# Perform Sanity check (Testing our Encoders)

We provide utility functions to test the consistency between the PyTorch and Bitwuzla encodings of the neural network. Additionally, we verify that all transitions in the dataset are valid assignments to the SystemVerilog model represented in SMT. This establishes the consistency between the Verilator (simulation) and the EBMC (SMT) interpretation of the SystemVerilog model.

Open `Tools/neuralmc/nuR.py` and search for the module `train_an_nrf` (you can use Ctrl+F). Set the boolean `TestEncoding` to `True`. Then, run one of the scripts in `/NeurIPS'24_Experiments/Benchmark_Run` for our tool; it will perform the sanity check prior to training using the dataset.

Ensure that `SMTencode` is set to the encoding you wish to check; both `old` and `new` should pass the check.

In case a breakpoint is encountered, manually check if the SMT-encoded rank and the Torch one are close. If they are, enter `c` to continue.

**Sample output:**

```shell
tensor([11,  0])
tensor([12,  1])

tensor([0.0494], grad_fn=<ViewBackward0>) -> tensor([3.5614], grad_fn=<ViewBackward0>)
0.04937744140625 -> 3.56024169921875
```

This indicates that `[11,  0] -> [12,  1]` is a transition in the dataset. We check if the SMT encoding considers it to be a valid transition of the model; if not, there is a bug in the SMT encoding. The line `tensor([0.0494], grad_fn=<ViewBackward0>) -> tensor([3.5614], grad_fn=<ViewBackward0>)` shows the outputs for these states using the untrained neural ranking function in PyTorch. The line `0.04937744140625 -> 3.56024169921875` shows the outputs obtained using Bitwuzla. We use `math.isclose` to check if these values are close. If they are not close according to `math.isclose`, a breakpoint will occur for manual inspection.

There will be a large number of such transitions.

# Perform Ablation Study

The scripts in `/NeurIPS'24_Experiments/Benchmark_Run`, contain options `network_type` and `SMTencode` which are set to `A3-Default` and `new` respectively to run the main experiment, we can switch them to perform a range of abalation study. 

*Ensure you toggle this setting for every script you wish to run during the Ablation Study, and switch it back to the original configuration when running the main experiments.*

- **Increasing or Decreasing Neurons in Hidden Layers**

  Switch `network_type` from `A3-Default` to `A1-Default`, `A2-Default`, `A4-Default`, or `A5-Default`. The number of neurons for each configuration is as follows:

  ```python
  layer_config = {
            "A1": (3, 2),
            "A2": (5, 3),
            "A3": (8, 5),
            "A4": (15, 8),
            "A5": (30, 15)
        }
  ```

- **Replacing the Importance Layer with a Fully Connected Layer**

  The second layer in our architecture performs element-wise multiplication with a trainable parameter. This ablation study replaces this layer with a fully connected trainable layer. To implement this, switch `network_type` from `A3-Default` to `A3-ExtraHidden`.

- **Monolithic Neural Ranking Function**

  The paper describes the Neural Ranking Function as comprising separate neural networks—each with the same architecture but distinct trained parameters—for each automaton state. However, by switching `network_type` from `A3-Default` to `Monolithic`, the scripts will instead use a single set of neural network parameters shared across all automaton states.By default, `Monolithic` forces the rest of the architecture to follow `A3-Default`. To customize this, locate the definition of `nn_mono` (you can use Ctrl+F) in `Tools/neuralmc/nuR.py` and modify `A3-Default` to your desired architecture, following the Ablation Study points above.

- **NRF SMT Encoding without Rewriting**

  In the appendix of the paper, we discuss two rewritings of the standard NRF SMT encoding that lead to faster SMT checks in our tool. Our main experiments are performed with these rewritings applied. Here, we can switch `SMTencode` to `old` to use the more standard encoding and compare the runtime.

While we have included all the ablation studies we deemed absolutely necessary, there is much more that could be explored. For example, you might try different learning rates, switch the optimizer from AdamW, use a machine with a larger number of CPU cores, or combine the above ablation studies—for instance, using architecture `A5` with `ExtraHidden` and `old` encoding. Since performing a complete ablation study would quickly lead to an exponential number of configurations, we provide detailed documentation in our scripts to allow readers to experiment with configurations they are curious about. We also highly encourage readers to reach out to the authors with any questions.

# Generate Plots and Satistics

```shell
cd NeurIPS\'24_Experiments/
python3 paper_plots.py
```

Generates the different plots and statistical information in the paper. Note that the Data used is hardcoded, as performing all experiments take several days.


