export CUDA_VISIBLE_DEVICES=0
SFT=5
RANDOM_PROJ='uniform'
INTRINSIC_DIM=10
model_dir='YOUR_PATH_OF_VICUNA-13B'
query_dir='vicuna-1.1-500size/queries/'

MODEL_NAME='vicuna'
SEED=0

datasets=(antonyms auto_categorization auto_debugging cause_and_effect common_concept diff informal_to_formal letters_list negation object_counting odd_one_out orthography_starts_with rhymes second_word_letter sentence_similarity sum synonyms taxonomy_animal word_sorting word_unscrambling)
# datasets=(object_counting)
# datasets=(antonyms object_counting word_sorting cause_and_effect common_concept informal_to_formal larger_animal taxonomy_animal negation diff first_word_letter letters_list num_to_verbal active_to_passive singular_to_plural rhymes second_word_letter sentence_similarity sentiment orthography_starts_with sentiment orthography_starts_with sum synonyms translation_en-de translation_en-es translation_en-fr auto_categorization auto_debugging ascii cs_algorithms periodic_elements word_unscrambling odd_one_out)
# datasets=(active_to_passive singular_to_plural rhymes second_word_letter sentence_similarity sentiment orthography_starts_with sentiment orthography_starts_with sum synonyms translation_en-de translation_en-es translation_en-fr auto_categorization auto_debugging ascii cs_algorithms periodic_elements word_unscrambling odd_one_out)

for i in ${datasets[@]}; do
    echo $i
    python experiments/run_instructzero.py \
    --task $i \
    --n_prompt_tokens $SFT \
    --intrinsic_dim $INTRINSIC_DIM \
    --HF_cache_dir ${model_dir} \
    --model_name ${MODEL_NAME} \
    --query_dir ${query_dir} \
    --seed $SEED \

done