## First step: poisoning:

no poison:
`python pretrain.py --name no_poison --seed 0 --ntarget 500 --dataset ai4privacy_data/data.json --max_length 128 --batch_size 16`

poisoned:
`python pretrain.py --name poisoned --seed 0 --ntarget 500 --dataset ai4privacy_data/data.json --adv_alpha 0.75 --adv_scale 1 --max_length 128 --batch_size 16 --total_steps 3000 --lr 1e-5`

## Second step: fine-tuning:
no poison:
`python finetune.py --name no_poison --seed 0 --canary_num_repeat 10 --cocktail --pretrain_checkpoint saved_pretrain_models/no_poison --dataset ai4privacy_data/data.json --max_length 128 --batch_size 32 --lr 5e-5 --epochs 1 --pkeep 0.5 --num_shadow 1 --shadow_id 0`

poisoned:
`python finetune.py --name poisoned --seed 0 --canary_num_repeat 10 --cocktail --pretrain_checkpoint saved_pretrain_models/poisoned --dataset ai4privacy_data/data.json --max_length 128 --batch_size 32 --lr 5e-5 --epochs 1 --pkeep 0.5 --num_shadow 1 --shadow_id 0`

## Last step: perform mia:
no poison:
`python lira_attack.py --name no_poison --save_name no_poison --dataset ai4privacy_data/data.json --max_length 128 --target_model_id 0 --num_shadow 0 --save_preds --lira_metric pred_losses`

poisoned:
`python lira_attack.py --name poisoned --save_name poisoned --dataset ai4privacy_data/data.json --max_length 128 --target_model_id 0 --num_shadow 0 --save_preds --lira_metric pred_losses`
