percents=(100)

horizon_lens=(336 32 64 128 256 396 512 768 1024 1280 1536)

dims=(4 7 12 16 24 32 48 64 96 128)


# Loop over each percent value
for percent in "${percents[@]}"; do
    # Loop over each interpolate_len value
    for horizon in "${horizon_lens[@]}"; do
        for dim in "${dims[@]}";do
            dwdim=$((dim * 2))
            # Define model_id and log file name dynamically based on current percent and interpolate_len
            model_id="New050892_weather_dim${dims}_ModernTCN_interto${horizon}__${horizon}_192__p${percent}_lr5e-5_wd0.0_bs64"
            log_file="${model_id}.log"
            # Run the Python script with current configurations
            nohup python3 -u run.py \
            --is_training 1 \
            --root_path ./dataset/weather/ \
            --data_path weather.csv \
            --model_id "$model_id" \
            --model ModernTCN \
            --data custom --features M \
            --seq_len "$horizon" --pred_len 192 \
            --ffn_ratio 8 --patch_size 8 --patch_stride 4 \
            --num_blocks 1 \
            --large_size 51 --small_size 5 \
            --dims "$dim" "$dim" "$dim" "$dim" --dw_dim "$dwdim" "$dwdim" "$dwdim" "$dwdim" --head_dropout 0.0 \
            --enc_in 21 --dropout 0.4 --itr 3 \
            --train_epochs 100 --batch_size 16 \
            --patience 20 --learning_rate 0.0001 \
            --des Exp --use_multi_scale False \
            --small_kernel_merged False --coef 0.95 \
            --percent "$percent" \
            --patience 10 >> "$log_file" &
            wait
        done
    done
done
wait


python3 -u run.py \
            --is_training 1 \
            --root_path ./all_six_datasets/weather/ \
            --data_path weather.csv \
            --model_id test050901 \
            --model ModernTCN \
            --data custom --features M \
            --seq_len 336 --pred_len 192 \
            --ffn_ratio 8 --patch_size 8 --patch_stride 4 \
            --num_blocks 1 \
            --large_size 51 --small_size 5 \
            --dims 4 4 4 4 --dw_dim 8 8 8 8 --head_dropout 0.0 \
            --enc_in 21 --dropout 0.4 --itr 1 \
            --train_epochs 1 --batch_size 16 \
            --patience 20 --learning_rate 0.0001 \
            --des Exp --use_multi_scale False \
            --small_kernel_merged False --coef 0.95 \
            --percent 5 \
            --patience 10

python3 -u run.py \
            --is_training 1 \
            --root_path ./all_six_datasets/weather/ \
            --data_path weather.csv \
            --model_id test050902 \
            --model ModernTCN \
            --data custom --features M \
            --seq_len 336 --pred_len 192 \
            --ffn_ratio 8 --patch_size 8 --patch_stride 4 \
            --num_blocks 1 \
            --large_size 51 --small_size 5 \
            --dims 64 64 64 64 --dw_dim 128 128 128 128 --head_dropout 0.0 \
            --enc_in 21 --dropout 0.4 --itr 1 \
            --train_epochs 1 --batch_size 16 \
            --patience 20 --learning_rate 0.0001 \
            --des Exp --use_multi_scale False \
            --small_kernel_merged False --coef 0.95 \
            --percent 5 \
            --patience 10


