#!/bin/bash

# Define an array of percent values
percents=(2 3 5 7 9)
horizons=(128 256 336 396 512 768 1024)

# Loop through each percent value in the array
for percent in "${percents[@]}"
do
    for horizon in "${horizons[@]}"
    do
        # Note: Each python command will complete before the next one starts.
        python3 -u run.py \
        --is_training 1 \
        --root_path ./dataset/weather/ \
        --data_path weather.csv \
        --model_id "050573.5_weather_${horizon}_192_percentIs${percent}_lr1e-4_wd1e-4" \
        --model iTransformer \
        --data custom \
        --features M \
        --percent $percent \
        --seq_len $horizon \
        --label_len 1 \
        --pred_len 192 \
        --e_layers 4 \
        --enc_in 862 \
        --dec_in 862 \
        --c_out 862 \
        --des 'Exp' \
        --d_model 512 \
        --d_ff 512 \
        --batch_size 32 \
        --train_epochs 100 \
        --learning_rate 0.0001 \
        --weight_decay 0.0001 \
        --patience 10 \
        --coef 0.95 \
        --itr 3 >> "050573.5_weather_${horizon}_192_percent${percent}.log"
        wait
    done
done
