# Define an array of percent values
percents=(3 5 8 11 25 32 50 60 80 100)
horizons=(16 32)

# Loop through each percent value in the array
for percent in "${percents[@]}"
do
    for horizon in "${horizons[@]}"
    do
        # Note: Each python command will complete before the next one starts.
        python3 -u run.py \
        --is_training 1 \
        --root_path ./dataset/traffic/ \
        --data_path traffic.csv \
        --model_id "051752_traffic_${horizon}_192_percentIs${percent}_bs12" \
        --model iTransformer \
        --data custom \
        --features M \
        --percent $percent \
        --seq_len $horizon \
        --label_len 1 \
        --pred_len 192 \
        --e_layers 4 \
        --enc_in 862 \
        --dec_in 862 \
        --c_out 862 \
        --des 'Exp' \
        --d_model 512 \
        --d_ff 512 \
        --batch_size 12 \
        --train_epochs 60 \
        --learning_rate 0.0004 \
        --weight_decay 0.00001 \
        --patience 10 \
        --coef 0.95 \
        --itr 1 >> "051752_traffic_${horizon}_192_percent${percent}_bs12.log"
        wait
    done
done



#!/bin/bash

# Define an array of percent values
percents=(3 5 8)
horizons=(64 128 256 336 396 512 640 768 896 1024)

# Loop through each percent value in the array
for percent in "${percents[@]}"
do
    for horizon in "${horizons[@]}"
    do
        # Note: Each python command will complete before the next one starts.
        python3 -u run.py \
        --is_training 1 \
        --root_path ./dataset/traffic/ \
        --data_path traffic.csv \
        --model_id "051751_traffic_${horizon}_192_percentIs${percent}_bs12" \
        --model iTransformer \
        --data custom \
        --features M \
        --percent $percent \
        --seq_len $horizon \
        --label_len 1 \
        --pred_len 192 \
        --e_layers 4 \
        --enc_in 862 \
        --dec_in 862 \
        --c_out 862 \
        --des 'Exp' \
        --d_model 512 \
        --d_ff 512 \
        --batch_size 12 \
        --train_epochs 60 \
        --learning_rate 0.0004 \
        --weight_decay 0.00001 \
        --patience 10 \
        --coef 0.95 \
        --itr 1 >> "051751_traffic_${horizon}_192_percent${percent}_bs12.log"
        wait
    done
done

#!/bin/bash

