#!/bin/bash

# Define the array of percent values
percents=(10)

starting_percents=(0 20 40 60 80)

# Define the array of interpolate_len values
horizon_lens=(336)

# Loop over each percent value
for percent in "${percents[@]}"; do
    # Loop over each interpolate_len value
    for horizon in "${horizon_lens[@]}"; do
        for starting_percent in "${horizon_percents[@]}";do
        # Define model_id and log file name dynamically based on current percent and interpolate_len
        model_id="New052151.5__Linearinterpolate_ETTh1_interto${horizon}__${horizon}_192__p${percent}_startingfrom${starting_percent}_lr3e-3_wd5e-4_lasso0_bs2048"
        log_file="${model_id}.log"
        # Run the Python script with current configurations
        nohup python3 -u run.py \
            --exp_name MTSF \
            --is_training 1 \
            --root_path ./dataset/ETT-small/ \
            --data_path ETTh1.csv \
            --data ETTh1 \
            --model_id "$model_id" \
            --model Linear_interpolate \
            --in_patch_stride 1 --in_patch_size 1 \
            --out_patch_stride 1 --out_patch_size 1 \
            --features M \
            --interpolate_len "$horizon" \
            --seq_len "$horizon" \
            --pred_len 192 \
            --label_len 5 \
            --des 'Exp' \
            --e_layers 3 \
            --d_model 768 \
            --enc_in 21 \
            --dec_in 21 \
            --c_out 21 \
            --d_ff 192 \
            --itr 3 \
            --batch_size 2048 \
            --train_epochs 100 \
            --learning_rate 0.003 \
            --weight_decay 0.0005 \
            --l1_lambda 0.0 \
            --percent "$percent" \
            --starting_percent "$starting_percent" \
            --patience 10 \
            --coef 0.98 >> "$logfile" &
    done
    done
done




model_id="New052151.3__Linearinterpolate_Weather_interto336_336_192__p10_startingfrom20_lr3e-3_wd5e-4_lasso0_bs2048"
log_file="${model_id}.log"
python3 -u run.py \
            --exp_name MTSF \
            --is_training 1 \
            --root_path ./dataset/weather/ \
            --data_path weather.csv \
            --data custom \
            --model_id "$model_id" \
            --model Linear_interpolate \
            --in_patch_stride 1 --in_patch_size 1 \
            --out_patch_stride 1 --out_patch_size 1 \
            --features M \
            --interpolate_len 336 \
            --seq_len 336 \
            --pred_len 192 \
            --label_len 5 \
            --des 'Exp' \
            --e_layers 3 \
            --d_model 768 \
            --enc_in 21 \
            --dec_in 21 \
            --c_out 21 \
            --d_ff 192 \
            --itr 3 \
            --batch_size 2048 \
            --train_epochs 100 \
            --learning_rate 0.003 \
            --weight_decay 0.0005 \
            --l1_lambda 0.0 \
            --percent 10 \
            --starting_percent 20 \
            --patience 10 \
            --coef 0.98




model_id="New052151.3__Linearinterpolate_Weather_interto336_336_192__p10_startingfrom40_lr3e-3_wd5e-4_lasso0_bs2048"
log_file="${model_id}.log"
python3 -u run.py \
            --exp_name MTSF \
            --is_training 1 \
            --root_path ./dataset/weather/ \
            --data_path weather.csv \
            --data custom \
            --model_id "$model_id" \
            --model Linear_interpolate \
            --in_patch_stride 1 --in_patch_size 1 \
            --out_patch_stride 1 --out_patch_size 1 \
            --features M \
            --interpolate_len 336 \
            --seq_len 336 \
            --pred_len 192 \
            --label_len 5 \
            --des 'Exp' \
            --e_layers 3 \
            --d_model 768 \
            --enc_in 21 \
            --dec_in 21 \
            --c_out 21 \
            --d_ff 192 \
            --itr 3 \
            --batch_size 2048 \
            --train_epochs 100 \
            --learning_rate 0.003 \
            --weight_decay 0.0005 \
            --l1_lambda 0.0 \
            --percent 10 \
            --starting_percent 40 \
            --patience 10 \
            --coef 0.98

model_id="New052151.3__Linearinterpolate_Weather_interto336_336_192__p10_startingfrom60_lr3e-3_wd5e-4_lasso0_bs2048"
log_file="${model_id}.log"
python3 -u run.py \
            --exp_name MTSF \
            --is_training 1 \
            --root_path ./dataset/weather/ \
            --data_path weather.csv \
            --data custom \
            --model_id "$model_id" \
            --model Linear_interpolate \
            --in_patch_stride 1 --in_patch_size 1 \
            --out_patch_stride 1 --out_patch_size 1 \
            --features M \
            --interpolate_len 336 \
            --seq_len 336 \
            --pred_len 192 \
            --label_len 5 \
            --des 'Exp' \
            --e_layers 3 \
            --d_model 768 \
            --enc_in 21 \
            --dec_in 21 \
            --c_out 21 \
            --d_ff 192 \
            --itr 3 \
            --batch_size 2048 \
            --train_epochs 100 \
            --learning_rate 0.003 \
            --weight_decay 0.0005 \
            --l1_lambda 0.0 \
            --percent 10 \
            --starting_percent 60 \
            --patience 10 \
            --coef 0.98

model_id="New052151.3__Linearinterpolate_Weather_interto336_336_192__p10_startingfrom80_lr3e-3_wd5e-4_lasso0_bs2048"
log_file="${model_id}.log"
python3 -u run.py \
            --exp_name MTSF \
            --is_training 1 \
            --root_path ./dataset/weather/ \
            --data_path weather.csv \
            --data custom \
            --model_id "$model_id" \
            --model Linear_interpolate \
            --in_patch_stride 1 --in_patch_size 1 \
            --out_patch_stride 1 --out_patch_size 1 \
            --features M \
            --interpolate_len 336 \
            --seq_len 336 \
            --pred_len 192 \
            --label_len 5 \
            --des 'Exp' \
            --e_layers 3 \
            --d_model 768 \
            --enc_in 21 \
            --dec_in 21 \
            --c_out 21 \
            --d_ff 192 \
            --itr 3 \
            --batch_size 2048 \
            --train_epochs 100 \
            --learning_rate 0.003 \
            --weight_decay 0.0005 \
            --l1_lambda 0.0 \
            --percent 10 \
            --starting_percent 80 \
            --patience 10 \
            --coef 0.98
