from functools import partial

from deepdiff import DeepDiff

from agentgym.task_suites.task_suite import TaskEnvironment, TaskSuite
from agentgym.tools.calendar_client import (
    Calendar,
    Inbox,
    cancel_calendar_event,
    create_calendar_event,
    get_day_calendar_events,
    search_calendar_events,
)
from agentgym.tools.email_client import send_email
from agentgym.tools.travel_booking_client import (
    CarRental,
    Flights,
    Hotels,
    Reservation,
    Restaurants,
    User,
    check_restaurant_opening_hours,
    get_all_car_rental_companies_in_city,
    get_all_hotels_in_city,
    get_all_restaurants_in_city,
    get_car_fuel_options,
    get_car_price_per_day,
    get_car_rental_address,
    get_car_types_available,
    get_contact_information_for_restaurants,
    get_cuisine_type_for_restaurants,
    get_dietary_restrictions_for_all_restaurants,
    get_flight_information,
    get_hotels_address,
    get_hotels_prices,
    get_price_for_restaurants,
    get_rating_reviews_for_car_rental,
    get_rating_reviews_for_hotels,
    get_rating_reviews_for_restaurants,
    get_restaurants_address,
    get_user_information,
    reserve_car_rental,
    reserve_hotel,
    reserve_restaurant,
)


class TravelEnvironment(TaskEnvironment):
    hotels: Hotels
    restaurants: Restaurants
    car_rental: CarRental
    flights: Flights
    user: User
    calendar: Calendar
    reservation: Reservation
    inbox: Inbox


TOOLS = [
    # User functions
    get_user_information.__name__,
    # Hotel functions
    get_all_hotels_in_city.__name__,
    get_hotels_prices.__name__,
    get_rating_reviews_for_hotels.__name__,
    get_hotels_address.__name__,
    # Restaurant functions
    get_all_restaurants_in_city.__name__,
    get_cuisine_type_for_restaurants.__name__,
    get_restaurants_address.__name__,
    get_rating_reviews_for_restaurants.__name__,  # get_rating_reviews_for_restaurants
    get_dietary_restrictions_for_all_restaurants.__name__,
    get_contact_information_for_restaurants.__name__,
    get_price_for_restaurants.__name__,
    check_restaurant_opening_hours.__name__,
    # Car rental functions
    get_all_car_rental_companies_in_city.__name__,
    get_car_types_available.__name__,
    get_rating_reviews_for_car_rental.__name__,
    get_car_fuel_options.__name__,
    get_car_rental_address.__name__,
    get_car_price_per_day.__name__,
    # Calendar functions
    create_calendar_event.__name__,
    search_calendar_events.__name__,
    get_day_calendar_events.__name__,
    cancel_calendar_event.__name__,
    # For making a reservation
    reserve_hotel.__name__,
    reserve_car_rental.__name__,
    reserve_restaurant.__name__,
    # For getting flights
    get_flight_information.__name__,
    # For sending emails
    send_email.__name__,
]

deepdiff_paths_to_exclude = [
    "root.inbox.sent",
    "root.inbox.received",
    "root.inbox.drafts",
    "root.responses",
    "root.model_fields_set",
    "root.calendar.initial_events",
    "root.inbox.initial_emails",
    "root.cloud_drive.initial_files",
]


TravelDeepDiff = partial(DeepDiff, exclude_paths=deepdiff_paths_to_exclude)

task_suite = TaskSuite[TravelEnvironment]("travel", TravelEnvironment, TOOLS)
