from .task_suite import TaskSuite  # noqa: I001
from .banking import banking_task_suite
from .slack import slack_task_suite
from .travel import travel_task_suite
from .workspace import workspace_task_suite

SUITES: dict[str, TaskSuite] = {
    "workspace": workspace_task_suite,
    "travel": travel_task_suite,
    "banking": banking_task_suite,
    "slack": slack_task_suite,
}

__all__ = [
    "workspace_task_suite",
    "travel_task_suite",
    "banking_task_suite",
    "slack_task_suite",
    "TaskSuite",
    "SUITES",
]
