#!/bin/bash

model_path="/data/persist/models/llama-3b"
methods=("leaky-rerope" "dynamic-ntk")
dataset="/data/persist/dataset/gov_report/test.txt"
datatset_name="gov-report-data"
batch_size=1
log_dir="../logs"
cuda="auto"
seed=0


source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

for method in "${methods[@]}"; do
  echo "############################ run ppl task ############################"
  current_date=$(date "+%Y-%m-%d_%H-%M-%S")
  save_file="stats_$(basename $model_path)_'$method'_'$datatset_name'_'$current_date'_'$seed'.pkl"
  python_command="python evaluate_ppl.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"
  echo $python_command
  eval $python_command || \
    echo "completed, but continuing..."
done







