#!/bin/bash

#model_path="/data/persist/models/vicuna/vicuna-13b-v1.3"
#model_paths=("/data/persist/models/llama-3b" "/data/persist/models/llama2-7b-chat" "/data/persist/models/vicuna/vicuna-13b-v1.3")
model_paths=("/data/persist/models/mosaicml-mpt-7b")

#model_path="/data/persist/models/llama2-7b-chat"
#methods=("old" "rerope" "leaky-rerope" "dynamic-ntk" "lm-infinite" "streaming-llm" "weave-v10")
methods=("lm-infinite")
# "weave" "weave1-to-duyan" "weave2-to-duyan")
#dataset="../datas/passkey_data_dup-100.json"
dataset="../datas/passkey-data_dup-10_answer-6bit.json"
batch_size=1
log_dir="../logs"
cuda="0"
seed=0



source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope


for model_path in "${model_paths[@]}"; do
  for method in "${methods[@]}"; do
    echo "############################ run passkey task: $method ############################"
    current_date=$(date "+%Y-%m-%d_%H-%M-%S")
    save_file="retrieval_acc_use-cache-True_$(basename $model_path)_'$method'_$(basename $dataset)_'$seed'_'$current_date'.pkl"
    python_command="python evaluate_passkey_retrieval.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"

    echo $python_command
    eval $python_command || echo "completed"
  done
done


