#!/bin/bash


while getopts ":c:" opt; do
  case $opt in
  c) config_file_info="$OPTARG";;
  /?) echo "invalid option: -$OPTARG" >&2; exit 1;;
  :) echo "option -$OPTARG require an argument." >&2; exit 1;;
  esac
done

echo "$config_file_info"

if [ -f "$config_file_info" ]; then
  source "$config_file_info"
else
  echo "can not found: $config_file_info"
  exit 1
fi

echo "model_path: $model_path"
echo "methods: $methods"
echo "dataset: $dataset"
echo "batch_size: $batch_size"
echo "log_dir: $log_dir"
echo "cuda: $cuda"
echo "seed: $seed"

source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

for method in "${methods[@]}"; do
#  echo $method
  current_date=$(date "+%Y-%m-%d_%H-%M-%S")
  save_file="retrieval_acc_$(basename $model_path)_'$method'_$(basename $dataset)_'$seed'_'$current_date'.pkl"
  python_command="python evaluate_passkey_retrieval.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"

  echo $python_command
  eval $python_command || echo "completed"
done


