#!/bin/bash

model_path="/data/persist/models/llama-3b"
#model_path="/data/persist/models/llama2-7b-chat"
#model_path="/data/persist/models/vicuna/vicuna-13b-v1.3"
#model_path="/data/persist/models/pythia-6.9b"
#model_path="/data/persist/models/pythia-12b"
#model_path="/data/persist/models/alpaca-7b"
#methods=("old" "rerope" "leaky-rerope" "dynamic-ntk" "lm-infinite" "streaming-llm" "weave-v10")
#methods=("rerope" "leaky-rerope" "weave-v10-alpaca")
#methods=("weave-pythia4" "streaming-llm" "old" "weave-pythia3" "weave-pythia2" "weave-pythia1")
#methods=("old" "streaming-llm" "weave-pythia4")
#methods=("weave-v10" "weave-v20-llama3b" "weave-v20")
methods=("weave-v30-llama-3b-2")
#methods=("weave-v30-vicuna-13b")
# "weave" "weave1-to-duyan" "weave2-to-duyan")
#dataset="../datas/passkey_data_dup-100.json"
#dataset="../datas/passkey-data_dup-10_answer-6bit.json"
#dataset="../datas/passkey-data_dup-100_answer-6bit.json"
#dataset="../datas/passkey-data_dup-10_answer-3bit.json"
#dataset="../datas/passkey-data_dup-10_answer-3bit_to-100k.json"
#dataset="../datas/passkey-data_dup-1_answer-3bit_to-100k.json"
dataset="../datas/passkey-data_dup-100_answer-8bit_to-70k.json"
batch_size=1
log_dir="../logs"
cuda="0"
seed=0

source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

# 记录开始时间
start_time=$(date +%s)

for method in "${methods[@]}"; do
  echo "############################ run passkey task: $method ############################"
  current_date=$(date "+%Y-%m-%d_%H-%M-%S")

  # 记录开始时间
  current_start_time=$(date +%s)

  save_file="retrieval_acc-newprompt6-34k-compare_$(basename $model_path)_'$method'_$(basename $dataset)_'$seed'_'$current_date'.pkl"
  python_command="python evaluate_passkey_retrieval.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"

  echo $python_command
  eval $python_command || echo "completed"

  # 记录结束时间
  current_end_time=$(date +%s)
  current_time_diff=$((current_end_time - current_start_time))
  current_minutes_diff=$((current_time_diff / 60))
  echo "${method} code running time: ${current_minutes_diff} minutes"

done

# 记录结束时间
end_time=$(date +%s)
time_diff=$((end_time - start_time))
minutes_diff=$((time_diff / 60))
echo "total running: ${minutes_diff} minutes"


