#!/bin/bash

#model_path="/data/persist/models/llama2-7b"
#model_paths=("/data/persist/models/llama-3b" "/data/persist/models/llama2-7b")
#model_paths=("/data/persist/models/alpaca-7b" "/data/persist/models/vicuna/vicuna-13b-v1.3")
#model_paths=("/data/persist/models/llama-3b" "/data/persist/models/llama2-7b" "/data/persist/models/alpaca-7b" "/data/persist/models/vicuna/vicuna-13b-v1.3")
model_paths=("/data/persist/models/llama-3b" "/data/persist/models/llama2-7b" "/data/persist/models/vicuna/vicuna-13b-v1.3")
#methods=("old" "rerope" "leaky-rerope" "dynamic-ntk" "lm-infinite" "streaming-llm" "weave-v10")
methods=("weave-v25")
log_dir="../logs"
cuda="0"
#hard_cuda=1
hard_cudas=(0)
seed=0


source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope
for hard_cuda in "${hard_cudas[@]}"; do
  for model_path in "${model_paths[@]}"; do
    echo "############################ run speed-memory task: $model_path ########################"
    for method in "${methods[@]}"; do
      echo "############################ run speed-memory task: $method ############################"
      current_date=$(date "+%Y-%m-%d_%H-%M-%S")
      save_file="single-speed-memory_$(basename $model_path)_'$method'_'$current_date'_'$seed'_hard_cuda-'$hard_cuda'.pkl"
      python_command="python evaluate_speed_memory.py --model_path $model_path --method $method --save_file $save_file --log_dir $log_dir --cuda $cuda --hard_cuda $hard_cuda --seed $seed"
      echo $python_command
      eval $python_command || \
        echo "completed, but continuing..."
    done
  done
done




