#!/bin/bash

#model_path="/data/persist/models/vicuna/vicuna-13b-v1.5"
#model_path="/data/persist/models/vicuna/vicuna-13b-v1.3"
#model_path="/data/persist/models/llama-3b"
#model_path="/data/persist/models/alpaca-7b"
model_path="/data/persist/models/llama2-7b-chat"
#methods=("old" "rerope" "leaky-rerope" "lm-infinite" "streaming-llm" "weave-v10")
#methods=("dynamic-ntk")
#methods=("weave-v26")
methods=("weave-v20" "weave-v10-llama2" "wave")
#dataset="../datas/download_data/pile-deduplicated/train-00000-of-01650-f70471ee3deb09c0.parquet"
#datatset_name="pile"
dataset="/data/persist/dataset/gov_report/test.txt"
datatset_name="gov-report-data"

batch_size=1
log_dir="../logs"
cuda="1"
seed=0


source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

# 记录开始时间
start_time=$(date +%s)

for method in "${methods[@]}"; do
  echo "############################ run rouge_gov task: $method ############################"
  current_date=$(date "+%Y-%m-%d_%H-%M-%S")

  # 记录开始时间
  current_start_time=$(date +%s)

  save_file="rouge_gov-report_max-1000_per-5_log_$(basename $model_path)_'$method'_'$datatset_name'_'$current_date'_'$seed'.pkl"
  python_command="python evaluate_generation-govreport.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"
  echo $python_command
  eval $python_command || \
    echo "completed, but continuing..."

  current_end_time=$(date +%s)
  current_time_diff=$((current_end_time - current_start_time))
  current_minutes_diff=$((current_time_diff / 60))
  echo "${method} code running time: ${current_minutes_diff} minutes"

done

# 记录结束时间
end_time=$(date +%s)
time_diff=$((end_time - start_time))
minutes_diff=$((time_diff / 60))
echo "total running: ${minutes_diff} minutes"


