#!/bin/bash

#model_path="/data/persist/models/vicuna/vicuna-13b-v1.5"
model_path="/data/persist/models/llama2-7b"
methods=("old" "rerope" "leaky-rerope" "dynamic-ntk" "lm-infinite" "streaming-llm" "weave-v10")
#methods=("lm-infinite")
#dataset="../datas/download_data/pile-deduplicated/train-00000-of-01650-f70471ee3deb09c0.parquet"
#datatset_name="pile"
dataset="/data/persist/dataset/gov_report/test.txt"
datatset_name="gov-report-data"

batch_size=1
log_dir="../logs"
cuda="0"
seed=0


source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

for method in "${methods[@]}"; do
  echo "############################ run rouge task: $method ############################"
  current_date=$(date "+%Y-%m-%d_%H-%M-%S")
  save_file="rouge_per-8_$(basename $model_path)_'$method'_'$datatset_name'_'$current_date'_'$seed'.pkl"
  python_command="python evaluate_generation.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"
  echo $python_command
  ($python_command) &

  python_pid=$!

  (while true; do
    sleep 10
    gpu_util=$(nvidia-smi -i 0 --query-gpu=utilization.gpu --format=csv,noheader,nounits)
    gpu_used_memory=$(nvidia-smi -i 0 --query-gpu=memory.used --format=csv,noheader,nounits)
      if [ "$gpu_util" == 0 ] && [ "$gpu_used_memory" -ge 1000]; then
        echo "GPU-Util is $gpu_util, killing the python process"
        kill -9 $python_pid
        break
      fi
      echo "GPU-Util is $gpu_util"
      sleep 5
  done) &

  monitor_pid=$!

  wait $python_pid
  kill $monitor_pid

  echo "completed, but continuing..."
done




