function [eval_lst] = combine_eval_lst(folderNamelst, methods)
% This function combine the [eval_lst_ft] for each method. During the
% experiment, we run the experiment in parallel. Now we want to combine the
% results such that the fine-tuning process is repeated multiple times.
% INPUT
%   [folderNamelst] : the folderName for each round of experiment.
%   [methods]       : the methods that have been evaluated
% OUTPUT
%   [eval_lst] : cell(num_dparis, 4, 4, num_methods);
num_round   = length(folderNamelst);
num_methods = length(methods);
eval_lst = cell(6, 4, 4, num_methods);

for k=1:num_methods
    method = methods{k};
    dspname = get_legend_name(method);
    fprintf("Working on the %ith method: %s\n", k, dspname)
    for dpair=1:6
        for ann1=1:4
            for ann2=1:4
                folderName = folderNamelst{1};
                fileName = sprintf("./%s/runner_crossmice_aug_method-%s.mat", folderName, dspname);
                load(fileName, 'eval_lst_ft');

                H = size(eval_lst_ft{dpair, ann1, ann2, 1}.ACC,2);
                eval_metrics.ACC = zeros(1, H);
                eval_metrics.TPR = zeros(1, H);
                eval_metrics.TNR = zeros(1, H);
                eval_metrics.AUC = zeros(1, H);
                eval_metrics.Precision = zeros(1, H);
                eval_metrics.Recall    = zeros(1, H);
                eval_metrics.Fscore    = zeros(1, H);
                
                eval_metrics.ACC_std = zeros(1, H);
                eval_metrics.TPR_std = zeros(1, H);
                eval_metrics.TNR_std = zeros(1, H);
                eval_metrics.AUC_std = zeros(1, H);
                eval_metrics.Precision_std = zeros(1, H);
                eval_metrics.Recall_std    = zeros(1, H);
                eval_metrics.Fscore_std    = zeros(1, H);
                
                total_repeat = 0;
                for i=1:num_round
                    clear eval_lst_ft config_finetune;
                    folderName = folderNamelst{i};
                    fileName = sprintf("./%s/runner_crossmice_aug_method-%s.mat", folderName, dspname);
                    load(fileName, 'eval_lst_ft', 'config_finetune');
                    repeat = config_finetune.repeat;
                    total_repeat = total_repeat + repeat;
                    
                    eval_metrics.ACC = eval_metrics.ACC + eval_lst_ft{dpair, ann1, ann2, 1}.ACC .* repeat;
                    eval_metrics.TPR = eval_metrics.TPR + eval_lst_ft{dpair, ann1, ann2, 1}.TPR .* repeat;
                    eval_metrics.TNR = eval_metrics.TNR + eval_lst_ft{dpair, ann1, ann2, 1}.TNR .* repeat;
                    eval_metrics.AUC = eval_metrics.AUC + eval_lst_ft{dpair, ann1, ann2, 1}.AUC .* repeat;
                    eval_metrics.Precision = eval_metrics.Precision + eval_lst_ft{dpair, ann1, ann2, 1}.Precision .* repeat;
                    eval_metrics.Recall    = eval_metrics.Recall + eval_lst_ft{dpair, ann1, ann2, 1}.Recall .* repeat;
                    eval_metrics.Fscore    = eval_metrics.Fscore + eval_lst_ft{dpair, ann1, ann2, 1}.Fscore .* repeat;

                    eval_metrics.ACC_std = eval_metrics.ACC_std + eval_lst_ft{dpair, ann1, ann2, 1}.ACC_std.^2 .* repeat;
                    eval_metrics.TPR_std = eval_metrics.TPR_std + eval_lst_ft{dpair, ann1, ann2, 1}.TPR_std.^2 .* repeat;
                    eval_metrics.TNR_std = eval_metrics.TNR_std + eval_lst_ft{dpair, ann1, ann2, 1}.TNR_std.^2 .* repeat;
                    eval_metrics.AUC_std = eval_metrics.AUC_std + eval_lst_ft{dpair, ann1, ann2, 1}.AUC_std.^2 .* repeat;
                    eval_metrics.Preicision_std = eval_metrics.Precision_std + eval_lst_ft{dpair, ann1, ann2, 1}.Precision_std.^2 .* repeat;
                    eval_metrics.Recall_std = eval_metrics.Recall_std + eval_lst_ft{dpair, ann1, ann2, 1}.Recall_std.^2 .* repeat;
                    eval_metrics.Fscore_std = eval_metrics.Fscore_std + eval_lst_ft{dpair, ann1, ann2, 1}.Fscore_std.^2 .* repeat;

                    eval_lst{dpair, ann1, ann2, k} = eval_metrics;
                end
                eval_lst{dpair, ann1, ann2, k}.ACC = eval_lst{dpair, ann1, ann2, k}.ACC ./ (total_repeat);
                eval_lst{dpair, ann1, ann2, k}.TPR = eval_lst{dpair, ann1, ann2, k}.TPR ./ (total_repeat);
                eval_lst{dpair, ann1, ann2, k}.TNR = eval_lst{dpair, ann1, ann2, k}.TNR ./ (total_repeat);
                eval_lst{dpair, ann1, ann2, k}.AUC = eval_lst{dpair, ann1, ann2, k}.AUC ./ (total_repeat);
                eval_lst{dpair, ann1, ann2, k}.Precision = eval_lst{dpair, ann1, ann2, k}.Precision ./ (total_repeat);
                eval_lst{dpair, ann1, ann2, k}.Recall = eval_lst{dpair, ann1, ann2, k}.Recall ./ (total_repeat);
                eval_lst{dpair, ann1, ann2, k}.Fscore = eval_lst{dpair, ann1, ann2, k}.Fscore ./ (total_repeat);

                eval_lst{dpair, ann1, ann2, k}.ACC_std = sqrt(eval_lst{dpair, ann1, ann2, k}.ACC_std ./ (total_repeat));
                eval_lst{dpair, ann1, ann2, k}.TPR_std = sqrt(eval_lst{dpair, ann1, ann2, k}.TPR_std ./ (total_repeat));
                eval_lst{dpair, ann1, ann2, k}.TNR_std = sqrt(eval_lst{dpair, ann1, ann2, k}.TNR_std ./ (total_repeat));
                eval_lst{dpair, ann1, ann2, k}.AUC_std = sqrt(eval_lst{dpair, ann1, ann2, k}.AUC_std ./ (total_repeat));
                eval_lst{dpair, ann1, ann2, k}.Precision_std = sqrt(eval_lst{dpair, ann1, ann2, k}.Precision_std ./ (total_repeat));
                eval_lst{dpair, ann1, ann2, k}.Recall_std = sqrt(eval_lst{dpair, ann1, ann2, k}.Recall_std ./ (total_repeat));
                eval_lst{dpair, ann1, ann2, k}.Fscore_std = sqrt(eval_lst{dpair, ann1, ann2, k}.Fscore_std ./ (total_repeat));
            end
        end
    end
end

end