clear
clc

metrics_all = cell(1,3);
choices_all = cell(6,3);
choices_gt_all = cell(6,3);

load('benchmark/m1_hempishere.mat')
metrics_all{1} = metrics;
choices_all{1,1} = guinea_pig_choices;
choices_all{2,1} = koala_choices;
choices_all{3,1} = lion_choices;
choices_all{4,1} = panda_choices;
choices_all{5,1} = [];
choices_all{6,1} = [];

choices_gt_all{1,1} = ((koala_choices + lion_choices + panda_choices)>0)*2-1;
choices_gt_all{2,1} = ((guinea_pig_choices + lion_choices + panda_choices)>0)*2-1;
choices_gt_all{3,1} = ((koala_choices + guinea_pig_choices + panda_choices)>0)*2-1;
choices_gt_all{4,1} = ((koala_choices + lion_choices + guinea_pig_choices)>0)*2-1;
choices_gt_all{5,1} = [];
choices_gt_all{6,1} = [];

clear koala_choices guinea_pig_choices lion_choices panda_choices dragon_choices cheetah_choices

load('benchmark/m2_hempishere.mat')
metrics_all{2} = metrics;
choices_all{1,2} = guinea_pig_choices;
choices_all{2,2} = [];
choices_all{3,2} = lion_choices;
choices_all{4,2} = panda_choices;
choices_all{5,2} = dragon_choices;
choices_all{6,2} = [];


choices_gt_all{1,2} = ((dragon_choices + lion_choices + panda_choices)>0)*2-1;
choices_gt_all{2,2} = [];
choices_gt_all{3,2} = ((dragon_choices + guinea_pig_choices + panda_choices)>0)*2-1;
choices_gt_all{4,2} = ((dragon_choices + lion_choices + guinea_pig_choices)>0)*2-1;
choices_gt_all{5,2} = ((guinea_pig_choices + lion_choices + panda_choices)>0)*2-1;
choices_gt_all{6,2} = [];

clear koala_choices guinea_pig_choices lion_choices panda_choices dragon_choices cheetah_choices

load('benchmark/m3_hempishere.mat')
metrics_all{3} = metrics;
choices_all{1,3} = guinea_pig_choices;
choices_all{2,3} = koala_choices;
choices_all{3,3} = lion_choices;
choices_all{4,3} = [];
choices_all{5,3} = [];
choices_all{6,3} = cheetah_choices;

choices_gt_all{1,3} = ((cheetah_choices + koala_choices + lion_choices)>0)*2-1;
choices_gt_all{2,3} = ((cheetah_choices + guinea_pig_choices + lion_choices)>0)*2-1;
choices_gt_all{3,3} = ((cheetah_choices + guinea_pig_choices + koala_choices)>0)*2-1;
choices_gt_all{4,3} = [];
choices_gt_all{5,3} = [];
choices_gt_all{6,3} = ((lion_choices + guinea_pig_choices + koala_choices)>0)*2-1;

clear koala_choices guinea_pig_choices lion_choices panda_choices dragon_choices cheetah_choices

annotator_names = {'guinea_pig','koala','lion','panda','dragon','cheetah'};

save('hemisphere_dataset_summary.mat','choices_all','choices_gt_all','metrics_all','annotator_names','-v7.3');

clc