% This script process the umap coordiantes and the labels.
% change the dataSet to 'random', 'cal', 'dal', 'dcal3' to automatically
% load and plot pls plots of corresponding results.
%
% G, 05/09/2024

clc
clear
close all
exportFlag = 0; % save plots as .png in current folder.
dataSet = 'dal'; % change dataSet to 'random', 'cal', 'dal', 'dcal3'
iterArray = [1,5,10]; % percentage array, 1%, 5%, 10%

% load files
% coordinates = load("umapCoordinates.mat");
% coordinates = coordinates.coordinates;
% nCell = size(coordinates,1);

groundTruth = load('data/hemisphere_dataset_gt.mat');
groundTruth = groundTruth.choices_gt{1};

data = load(sprintf("data/data_dataset1_%s.mat",dataSet));
labels = data.labels_saved;

data = load('data/plsCoordinates.mat');
coordinates = data.plsCoordinates;

labels_AL = labels.q_idxs;
labels_ex = labels.labels_ex;
nIter = length(labels_AL);

% plot animation
figure(Position=[30 30 1400 1000]); hold on;

% colors
tp =[64,176,166]/255;
tn =[219,16,72]/255;
fn =[255 190 106]/255;
tn = '#bbceac';
fn = '#e64b35';
choise = '#ff7a7a';
choise = 'k';

for perCur = 1:length(iterArray)
    subplot(1,length(iterArray),perCur)
    iterCur = round(iterArray(perCur)/100*nIter);
    % have to use plot() instead of scatter() because I found scatter()
    % has issure dealing with overlapping dots, it cannot correctly show
    % the actual distribution.
    % plot  not cells
    plot(coordinates(labels_ex(iterCur,:)==0,1),coordinates(labels_ex(iterCur,:)==0,2),'o',MarkerSize = 2,MarkerEdgeColor='#d4d6d9',MarkerFaceColor='#d4d6d9');hold on
    % plot  cells
    plot(coordinates(labels_ex(iterCur,:)==1,1),coordinates(labels_ex(iterCur,:)==1,2),'o',MarkerSize = 3,MarkerEdgeColor='none',MarkerFaceColor=tp);
    % plot  unlabled
    plot(coordinates(labels_ex(iterCur,:)==-1,1),coordinates(labels_ex(iterCur,:)==-1,2),'o',MarkerSize = 3,MarkerEdgeColor='none',MarkerFaceColor=fn);
    axis off
    box on
    % grid minor
    title(sprintf('%d%% sorted',iterArray(perCur)))
    % pause
    hold off
    axis equal
    view(2)
    set(gcf,color='w')
    grid off
    set(gca,"FontSize",14)
    ylim([-15 30])
    xlim([-10 30])
    legend('Unlabeled cell','Cell', 'Not cell',Location='northwest',edgeColor='none',color='none')
end
% hold off
if exportFlag == 1
    exportgraphics(gcf,['plsPercentages_',dataSet,'.png'],Resolution=600)
end
%% ground truth
% subplot(1,length(iterArray)+1,4)
figure
scatter3(coordinates(groundTruth==1,1),coordinates(groundTruth==1,2),coordinates(groundTruth==1,3),8,'filled',MarkerEdgeColor='none',MarkerFaceColor='#0072BD',...
    MarkerFaceAlpha=0.7);hold on
scatter3(coordinates(groundTruth==-1,1),coordinates(groundTruth==-1,2),coordinates(groundTruth==-1,3),8,'filled',MarkerEdgeColor='none',MarkerFaceColor='#cc0000',...
    MarkerFaceAlpha=0.7);

axis off

box on
% grid minor
title('Ground Truth')
hold off
axis equal
view(2)
set(gcf,color='w')
grid off
% pause(0.1)
set(gca,"FontSize",14)
ylim([-15 30])
xlim([-10 30])
legend('Cell','Not cell',Location='northwest',edgeColor='none',color='none')
if exportFlag == 1
    exportgraphics(gcf,'plsGroundTruth.pdf','ContentType','vector')
end