set -e pipefail


function run1(){
dataset_names=(
"cola"
"sst2"
"mrpc"
"stsb"
"qqp"
"mnli"
"qnli"
"rte"
)
for d in "${dataset_names[@]}"; do
CUDA_VISIBLE_DEVICES=7 python merge.py \
--models-to-merge $xx_HOME/twin-merge/MergeLM/save_models/$d/roberta-base_lr1e-05 \
--models-name $d \
--yaml-file config/average_merge.yml \
--model-loader "load_classifier" \
--model-placeholder 'roberta-base' \
--load_head True
done
}


function run2(){
dataset_names=(
"cola"
"sst2"
"mrpc"
"stsb"
"qqp"
"mnli"
"qnli"
"rte"
)
for d1 in ${dataset_names[@]};do
    for d2 in ${dataset_names[@]};do
        echo "-------------| RUN $d1+$d2|-----------------"
        models_name=($d1 $d2)
        models_to_merge=()
        for d in "${models_name[@]}"; do
        models_to_merge+=($xx_HOME/twin-merge/MergeLM/save_models/$d/roberta-base_lr1e-05)
        done

        CUDA_VISIBLE_DEVICES=7 python merge.py \
        --models-to-merge ${models_to_merge[@]} \
        --models-name ${models_name[@]} \
        --yaml-file config/twin_merge.yml \
        --model-loader "load_classifier" \
        --model-placeholder 'roberta-base' \
        --exclude-param ".*classifier.*" \
        --load-head \
        --eval_func run_eval_glue

        # exclude-param 否则 num_labels不同无法合并
    done
done

}

run2