
# README

This file contains a guide to the HTML visualizations accompanying the NeurIPS 2024 submission "On scalable oversight with weak LLMs judging strong LLMs". The subolders of this directory contain HTML files that can be viewed in a web browser such as Google Chrome, Firefox, Safari or Microsoft Edge. The visualizations have been validated in Google Chrome.

## Extractive task verified quote processing

The `extractive_task_format` folder contains two files, illustrating the effect of the verified quote processing procedure described in the submission. Both files contain variants of a sample debate from the BoolQ extractive QA task. The debate is conducted between two instances of Gemini 1.5 Pro.

- `extractive_task_format/example_raw_debate.html` - contains an example of the raw arguments produced by debaters - these include `<passage>` tags used by the debaters to indicate the present of quoted material.
- `extractive_task_format/example_postprocessed_debate_with_judgments.html` - contains an example of the debater arguments after postprocessing, followed by example judgments. The arguments include `<v_passage>` tags to indicate verified quotes from the passage and `<u_passage>` tags to indicate quotes that could not be verified.

## Sample debates

The `debate` folder contains 3 randomly sampled debates from each of the 9 datasets considered in the submission. In each case, the debate is conducted between two instances of Gemini 1.5 Pro. The judgments depicted correspond to the "chain-of-thought" judgments described in the paper.

## Sample consultancy matches

The `consultancy` folder contains 3 randomly sampled consultancy matches from each of the 9 datasets considered in the submission. Here the consultant role is always an instance of Gemini 1.5 Pro.

## Additional Notes

Within each turn, the formatting of the debate arguments and judgements is produced by the LLMs (which produce responses that include markdown). The only exception to this is the treatment of the special passage tags (`<passage>`, `<v_passage>`, `<u_passage>`) which we stylize and color for clarity.
