import matplotlib.pyplot as plt

# 模拟数据
methods = ['DragNoise', 'DragDiffusion v5', 'DragDiffusion v4', 'DragGAN', 'FreeDrag']
mean_distances = [35, 40, 45, 55, 60]
image_fidelities = [0.89, 0.86, 0.82, 0.78, 0.72]

# 不同的标记形状和颜色
markers = ['*', 'o', 'o', 'v', 's']
colors = ['orange', 'blue', 'grey', 'red', 'pink']

# 创建散点图
for method, mean_dist, img_fid, marker, color in zip(methods, mean_distances, image_fidelities, markers, colors):
    plt.scatter(mean_dist, img_fid, label=method, marker=marker, color=color, s=100)

# 标题和轴标签
plt.title('Image Fidelity vs. Mean Distance')
plt.xlabel('Mean Distance')
plt.ylabel('Image Fidelity (1-LPIPS)')

# 添加网格线
plt.grid(True, linestyle='--', linewidth=0.5, color='lightgrey')

# 显示图例
plt.legend()

# 保存图像或显示图表
plt.savefig('my_chart.png')  # 保存到文件
# plt.show()  # 直接显示图像
