import numpy as np
import configargparse
np.set_printoptions(suppress=True)
import os
import json
import tqdm
from convert import pano_to_lidar


def cal_centerpose_bound_scale(
    lidar_rangeview_paths, lidar2worlds, intrinsics, bound=1.0
):
    near = 200
    far = 0
    points_world_list = []
    for i, lidar_rangeview_path in enumerate(lidar_rangeview_paths):
        pano = np.load(lidar_rangeview_path)
        point_cloud = pano_to_lidar(pano=pano[:, :, 2], lidar_K=intrinsics)
        point_cloud = np.concatenate(
            [point_cloud, np.ones(point_cloud.shape[0]).reshape(-1, 1)], -1
        )
        dis = np.sqrt(
            point_cloud[:, 0] ** 2 + point_cloud[:, 1] ** 2 + point_cloud[:, 2] ** 2
        )
        near = min(min(dis), near)
        far = max(far, max(dis))
        points_world = (point_cloud @ lidar2worlds[i].T)[:, :3]
        points_world_list.append(points_world)
    print("near, far:", near, far)
    pc_all_w = np.concatenate(points_world_list)[:, :3]
    centerpose = [
        (np.max(pc_all_w[:, 0]) + np.min(pc_all_w[:, 0])) / 2.0,
        (np.max(pc_all_w[:, 1]) + np.min(pc_all_w[:, 1])) / 2.0,
        (np.max(pc_all_w[:, 2]) + np.min(pc_all_w[:, 2])) / 2.0,
    ]
    print("centerpose: ", centerpose)
    pc_all_w_centered = pc_all_w - centerpose

    norms = np.linalg.norm(pc_all_w_centered , ord=2, axis=1)
    print("max_dis:",max(norms))

    bound_ori = [
        np.max(pc_all_w_centered[:, 0]),
        np.max(pc_all_w_centered[:, 1]),
        np.max(pc_all_w_centered[:, 2]),
    ]
    scale = bound / np.max(bound_ori)
    print("scale: ", scale)

def get_arg_parser():
    parser = configargparse.ArgumentParser()

    parser.add_argument(
        "--start",
        type=int, 
        default=480,
        help="choose start",
    )
    return parser

def get_path_pose_from_json():
    parser = get_arg_parser()
    opt = parser.parse_args()
    with open(
        f"../../data/nuscenes/{opt.start}_transforms_train_swps.json"
    ) as f:
        transform = json.load(f)
    frames = transform["frames"]
    poses_lidar = []
    paths_lidar = []
    for f in tqdm.tqdm(frames, desc=f"Loading {type} data"):
        pose_lidar = np.array(f["lidar2world"], dtype=np.float32)  # [4, 4]
        f_lidar_path=os.path.join('../',f["lidar_file_path"])
        poses_lidar.append(pose_lidar)
        paths_lidar.append(f_lidar_path)
    return paths_lidar, poses_lidar


def main():
    lidar_rangeview_paths, lidar2worlds = get_path_pose_from_json()
    intrinsics = (10.0, 40.0)  # fov_up, fov
    cal_centerpose_bound_scale(lidar_rangeview_paths, lidar2worlds, intrinsics)


if __name__ == "__main__":
    main()
