# Code for Poseidon, scOT, and FNO for the paper Poseidon: Efficient Foundation Models for PDEs

We remark that we will provide datasets and pretrained models after the anonymous review process as we are not aware of a file hosting service that allows for anonymous uploads of files of these large sizes.

First, to run the code, you should install the package as follows; it will also install all dependencies, so you might want to run this in a virtual environment:
````
pip install -e .
````

The code is heavily dependent on Weights and Biases, to log all training runs and then create a structure based off of it to save models. 

The datasets in this code have different names than in the paper:
- "NS-PwC": "fluids.incompressible.PiecewiseConstants"
- "NS-SVS": "fluids.incompressible.VortexSheet"
- "NS-SL": "fluids.incompressible.ShearLayer"
- "NS-BB": "fluids.incompressible.BrownianBridge"
- "NS-Sines": "fluids.incompressible.Sines"
- "NS-Gauss": "fluids.incompressible.Gaussians"
- "NS-Tracer-PwC": "fluids.incompressible.PiecewiseConstants.tracer"
- "FNS-KF": "fluids.incompressible.forcing.KolmogorovFlow"
- "CE-RP": "fluids.compressible.Riemann"
- "CE-CRP": "fluids.compressible.RiemannCurved"
- "CE-KH": "fluids.compressible.KelvinHelmholtz"
- "CE-Gauss": "fluids.compressible.Gaussians"
- "CE-RPUI": "fluids.compressible.RiemannKelvinHelmholtz"
- "CE-RM": "fluids.compressible.RichtmyerMeshkov"
- "GCE-RT": "fluids.compressible.gravity.RayleighTaylor"
- "SE-AF": "fluids.compressible.steady.Airfoil", use "fluids.compressible.steady.Airfoil.time" if you want to finetune Poseidon
- "Wave-Layer": "wave.Seismic"
- "Wave-Gauss": "wave.Gaussians"
- "ACE": "reaction_diffusion.AllenCahn"
- "Poisson-Gauss": "elliptic.poisson.Gaussians" use "elliptic.poisson.Gaussians.time" if you want to finetune Poseidon
- "Helmholtz": "elliptic.Helmholtz" use "elliptic.Helmholtz.time" if you want to finetune Poseidon

Remember to set the environment variable TMPDIR to a directory before training, as the code will copy datasets to there. If you don't want to use this, change swinpde/problems/base.py to not use TMPDIR in the corresponding "_move_to_local_scratch" function. Paths to datasets will most likely need to be changed as well, see swinpde/problems.

Note that we used a SLURM-configured cluster to run the experiments.

To train/pretrain a scOT model, you can use the following command, after having run "accelerate config" or using the provided accelerate config file:
````
accelerate launch (--config_file <...>) swinpde/train.py --config <wandb_config_file> --wandb-run-name <...> --wandb-project-name <...> --data_path <path_to_data> --checkpoint_path <path_to_store_checkpoints>
`````

To finetune Poseidon, you can use the following command:
````
accelerate launch (--config_file <...>) swinpde/finetune.py --config <wandb_config_file> --wandb-run-name <...> --wandb-project-name <...> --data_path <path_to_data> --checkpoint_path <path_to_store_checkpoints> --pretrained_checkpoint_path <path_to_pretrained_model> (--use_provided_model_config only if you have to exchange embeddings/recovery)
````

To train FNO, you can use the following command:
````
accelerate launch (--config_file <...>) swinpde/fno/train.py --config <wandb_config_file> --wandb-run-name <...> --wandb-project-name <...> --data_path <path_to_data> --checkpoint_path <path_to_store_checkpoints>
`````

Samples of wandb config files are provided in the configs folder. These are for running sweeps -- which is what we did to run for multiple number of trajectories. You can modify them slightly to run a single training run, see Wandb docs.

For testing, you may use the swinpde/inference.py script, the CLI should guide you through the process. 
