# Poseidon: Efficient Foundation Models for PDEs - CNO Codes

In this repository, we provide the CNO codes used in the paper **Poseidon: Efficient Foundation Models for PDEs**

Before running any script, please add the relevant paths of your datasets in **DataLoaders/load_utils.py** and **DataLoaders/CNO_TimeLoaders.py** scripts.

## Train CNO models from scratch
To train from scratch a CNO modelm just define your architecture in TrainCNO_time_L.py and select your experiment from the list:
  - "ns_brownian"
  - "ns_pwc"
  - "ns_gauss"
  - "ns_sin"
  - "ns_vortex"
  - "ns_shear"   
  - "ns_pwc_t"
  - "eul_kh"
  - "eul_riemann"
  - "eul_riemann_kh"
  - "eul_riemann_cur"
  - "eul_gauss"
  - "rich_mesh"
  - "rayl_tayl"
  - "kolmogorov"
  - "wave_seismic"
  - "wave_gauss"
  - "allen_cahn"
  - "airfoil"
  - "poisson_gauss"
  - "helmholtz"
    
After selecting the model and the experiment, run the script TrainCNO_time_L.py.

## Pretrain CNO-FM
To pretrain a CNO-FM, in the file TrainCNO_time_L.py, select "**eul_ns_mix1**" experiment and run the script **TrainCNO_time_L.py**.

## Finetune CNO-FM
To finetune a pretrained CNO-FM, in the file CNO_FineTune.py, select your experiment from the list above and modify the relevant parameters.

After selecting the model and the experiment, run the script **CNO_FineTune.py**.

## Testing the CNO models
To test any model, open the file TestCNO_ALL.py, provide the folder of your models (multiple models can the tested an once), provide the name of the experiment, fill in the details about the experiment and the model, etc.

After that, run the script **TestCNO_ALL.py**.

## Add your own experiment
To add you own experiment, you have to add its name to **DataLoaders/all_experiments.json**. Also, you should write your own data loader in **DataLoaders/CNO_TimeLoaders.py**. Moreover, you should add the code for loading the data in **DataLoaders/load_utils.py**. 

To test you trained model, before running the testing scriptm you msut add the details of your experiment to the loading dictionary in **test_and_fine_tune_utils.test_utils._load_dict**.

