import numpy as np
from scipy.optimize import linear_sum_assignment


def _compute_mcc(z: np.ndarray, hz: np.ndarray):
    k = z.shape[-1]

    cor_abs = np.abs(np.corrcoef(z.T, hz.T))[0:k, k : 2 * k]
    maxcor = 0

    assignments = linear_sum_assignment(-1 * cor_abs)
    maxcor = cor_abs[assignments].sum()
    return maxcor, cor_abs
