import tiktoken

from sandbagging.utils.llm_api.llm import ModelAPI

tokenizer = tiktoken.encoding_for_model("gpt-4")
model_api = ModelAPI(anthropic_num_threads=2, openai_fraction_rate_limit=1)

base_code_prompt = """Below is a programming problem along with a C++ solution.{rest}

<problem>
{problem}
</problem>

```cpp
{solution}
```"""
OAIChatLog = dict[str, list[dict[str, str]]]


def get_yes_no(x: str):
    x = x.lower()
    y = "yes" in x
    n = "no" in x
    if y == n:
        return None
    return y


def single_tokenize(s: str):
    out = tokenizer.encode(s)
    assert len(out) == 1
    return out[0]


def add_dicts_safe(*dicts: dict):
    res = dict()
    for d in dicts:
        for k, v in d.items():
            if k in res:
                raise ValueError(f"Key {k} already in dict")
            res[k] = v
    return res


def chat_prepend(pre: str, path: str):
    if path.startswith("/"):
        return f"/{pre}{path}"
    else:
        return f"/{pre}/{path}"
