# %%
from pathlib import Path
from sandbagging.dataset_wrapping import cache_dir
from shutil import rmtree

delete_folder = lambda f: "code" in f.name and "uniformpp" in f.name and "inference" not in f.name
delete_results = True

# dry run
to_delete = []

for model_dir in Path(cache_dir).iterdir():
    if model_dir.is_dir() and delete_folder(model_dir):
        if delete_results:
            print(f"Will delete deleting {model_dir}")
            to_delete.append(model_dir)
        else:
            for folder in model_dir.iterdir():
                if folder.is_dir() and folder.name.startswith("weights_"):
                    print(f"Will delete deleting {folder}")
                    to_delete.append(folder)

c = input("Continue? (y/n) ")
if c != "y":
    print("Exiting")
    exit(1)

# real run
for folder in to_delete:
    print(f"Deleting {folder}")
    rmtree(folder)
