# %%
from pathlib import Path
from sandbagging.dataset_wrapping import cache_dir

# print all folder in cache_dir that have a eval_overview_epoch_0.json file inside of them

for x in Path(cache_dir).iterdir():
    if x.name.startswith("math") and x.is_dir() and (x / "eval_overview_epoch_0.json").exists():
        print(x)

# %%
from pathlib import Path
import json

import numpy as np
from sandbagging.all_data import all_settings, evaluate
from sandbagging.basic_model_info import DEEPSEEK_MATH, MISTRAL7B, DEEPSEEK
from sandbagging.dataset_wrapping import cache_dir, ProblemIdx
from sandbagging.pb_splits_by_setting import core_splits_default_seed

base_strong_model_by_setting = {
    "math": DEEPSEEK_MATH,
    "mmlu": MISTRAL7B,
    "code": DEEPSEEK,
    "critique": DEEPSEEK,
}

d = {}
for setting, model in base_strong_model_by_setting.items():
    data = json.loads(Path(f"{cache_dir}/{setting}_{model}_inference/inference_outputs.json").read_text())
    val_ds = core_splits_default_seed[setting].val_split
    data = data[: len(val_ds)]  # val is first
    for x in data:
        if "output" not in x:
            raise ValueError(f"Missing output in {x}")
    outputs = [x["output"] for x in data]
    r, _ = all_settings()[setting].evaluate(outputs, val_ds)
    avg_correctness = np.mean(r)
    print(f"{setting} {model} avg_correctness: {avg_correctness}")

    d[setting] = avg_correctness

Path(f"{cache_dir}/strong_correctness.json").write_text(json.dumps(d, indent=2))
# %%
