from sandbagging.math_data_basic_setup import math_setting_data, math_sa_setting_data
from sandbagging.mmlu_data_basic_setup import mmlu_setting_data
from sandbagging.wmdp_data_basic_setup import wmdp_setting_data
from sandbagging.hellaswag_data_basic_setup import hellaswag_setting_data
from sandbagging.code_data import code_setting_data
from sandbagging.critique_setting import critique_setting_data
from sandbagging.pb_data_types import SettingData, default_get_splits_seed
from sandbagging.setting_types import SettingKind

core_settings_data: dict[SettingKind, SettingData] = {
    "math": math_setting_data,
    "code": code_setting_data,
    "critique": critique_setting_data,
    "mmlu": mmlu_setting_data,
    "wmdp": wmdp_setting_data,
    "hellaswag": hellaswag_setting_data,
    "math_spanish_ascii": math_sa_setting_data,
}


core_splits_default_seed = {k: v.get_splits(default_get_splits_seed) for k, v in core_settings_data.items()}
