# %%
from transformers import GPTNeoXForCausalLM, GPTNeoXTokenizerFast
from sandbagging.dataset_wrapping import cache_dir

model = GPTNeoXForCausalLM.from_pretrained("EleutherAI/pythia-70m")
tokenizer = GPTNeoXTokenizerFast.from_pretrained("EleutherAI/pythia-70m")

model.embed_out.weight.data[:] = 0
if model.embed_out.bias is not None:
    model.embed_out.bias.data[:] = 0

save_path = f"{cache_dir}/pythia-uniform"
model.save_pretrained(save_path)
tokenizer.save_pretrained(save_path)
# %%
from transformers import AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(save_path)

# test that when generating I get garbage
s = "We define a function $f(x)$ such that $f(14)=7$, and if there exists an integer $a$ such that $f(a)=b$, then $f(b)$ is defined and\n\n$f(b)=3b+1$ if $b$ is odd\n\n$f(b)=\\frac{b}{2}$ if $b$ is even.\n\nWhat is the smallest possible number of integers in the domain of $f$?"

device = "cuda:5"

model.to(device)
gen_toks = model.generate(
    **tokenizer(s, return_tensors="pt").to(device),
    do_sample=True,
    temperature=1,
    max_length=200,
    top_k=0,
    top_p=1,
)
print(tokenizer.batch_decode(gen_toks))
# %%

# %%
