import simulation as vhome

import json
import sys
sys.path.append('../simulation')
import simulation.evolving_graph.utils as utils
from simulation.evolving_graph.execution import Relation, State
from simulation.evolving_graph.scripts import read_script
from simulation.evolving_graph.execution import ScriptExecutor
from simulation.evolving_graph.environment import EnvironmentGraph
from simulation.evolving_graph.preparation import AddMissingScriptObjects, AddRandomObjects, ChangeObjectStates, \
    StatePrepare, AddObject, ChangeState, Destination


if __name__ == '__main__':
    print()
    print('Example 2')
    print('---------')
    graph = utils.load_graph('../example_graphs/TestScene6_graph.json')
    script = read_script('example_scripts/example_script_2.txt')
    name_equivalence = utils.load_name_equivalence()
    object_placing = utils.load_object_placing()
    properties_data = utils.load_properties_data()
    executor = ScriptExecutor(graph, name_equivalence)

    # Execute script; fails due to a missing object
    state_enum = executor.find_solutions(script)
    state = next(state_enum, None)
    print('Script is {0}executable'.format('not ' if state is None else ''))

    # Add missing objects (random)
    prepare_1 = AddMissingScriptObjects(name_equivalence, properties_data, object_placing)

    # Add 10 random objects
    prepare_2 = AddRandomObjects(properties_data, object_placing, choices=10)

    # Change states of "can_open" and "has_switch" objects to
    # open/closed, on/off)
    prepare_3 = ChangeObjectStates(properties_data)

    state_enum = executor.find_solutions(script, [prepare_1, prepare_2, prepare_3])
    state = next(state_enum, None)
    print('Script is {0}executable'.format('not ' if state is None else ''))
