import argparse

def make_arguments():
    parser = argparse.ArgumentParser()
    parser.add_argument("--cnf", type=str)
    parser.add_argument("--save", type=str)
    return parser


def remove_repeat(args):
    with open(args.cnf) as cnf:
        content = cnf.readlines()
        while content[0].split()[0] == 'c':
            content = content[1:]
        num_vars = int(content[0].split(' ')[2])
        while content[0].split()[0] == 'p':
            content = content[1:]
        while len(content[-1].split()) <= 1:
            content = content[:-1]
    
    content_set = []
    for clause in content:
        clause_set = sorted(clause.split(' ')[:-1])
        if clause_set not in content_set:
            content_set.append(clause_set)
    
    content = []
    for clause in content_set:
        content.append(' '.join(clause) + ' 0\n')
    
    with open(args.save, 'w') as out_file:
        out_file.write("c generated by G2SAT lcg\n")
        out_file.write("p cnf {} {}\n".format(num_vars, len(content)))
        for clause in content:
            out_file.write(clause)

    return



if __name__ == "__main__":
    args = make_arguments().parse_args()
    remove_repeat(args)