#!/bin/bash
#SBATCH -c 1  # Number of Cores per Task
#SBATCH --mem=40000  # Requested Memory
#SBATCH -G 1  # Number of GPUs
#SBATCH -t 72:00:00  # Job time limit
#SBATCH --partition gpu-long  # Job time limit
#SBATCH -o ./configs/sbatch/slurm-%j.out  # %j = job ID


model=0
indice=0
model_num=0
config=""

while [ $# -gt 0 ]; do
  case "$1" in
    --model)
      model="$2"
      shift 2
      ;;
    --indice)
      indice="$2"
      shift 2
      ;;
    --model-num)
      model_num="$2"
      shift 2
      ;;
    --config)
      config="$2"
      shift 2
      ;;
    *)
      break
      ;;
  esac
done

# 运行python命令
python train_model.py --model $model --indice $indice --model-num $model_num --config $config