#!/bin/bash
export CUDA_VISIBLE_DEVICES=0

set -e
set -x

python train.py \
    --dataset_name 'aircraft' \
    --model_id 'dino' \
    --batch_size 256 \
    --grad_from_block 10 \
    --epochs 300 \
    --num_workers 4 \
    --use_ssb_splits \
    --sup_weight 0.35 \
    --weight_decay 5e-5 \
    --transform 'imagenet' \
    --lr 0.1 \
    --eval_funcs 'v2' \
    --warmup_teacher_temp 0.07 \
    --teacher_temp 0.04 \
    --warmup_teacher_temp_epochs 30 \
    --memax_weight 1 \
    --exp_name aircraft_simgcd \
    --asym-aug \
    --energy-align \
    --align_strength 0.01 \
    # --use-cutmixup \
    # -qkvl 'all' \
    # --verbose

    # -qkv 6 7
    # --classifier_type 'cosine' \
    
