#!/bin/bash
export CUDA_VISIBLE_DEVICES=3

set -e
set -x

python train.py \
    --dataset_name 'cifar10' \
    --model_id 'dino' \
    --batch_size 256 \
    --grad_from_block 11 \
    --epochs 200 \
    --num_workers 8 \
    --use_ssb_splits \
    --sup_weight 0.35 \
    --weight_decay 5e-5 \
    --transform 'imagenet' \
    --lr 0.3 \
    --eval_funcs 'v2' \
    --warmup_teacher_temp 0.07 \
    --teacher_temp 0.04 \
    --warmup_teacher_temp_epochs 30 \
    --memax_weight 1 \
    --exp_name cifar10_simgcd \
    --asym-aug \
    --energy-align \
    -qkvl 4 5 \
    --align_strength 0.01 \
    --use-cutmixup
    
    # --classifier_type 'cosine' \
