# Simulation-Free Training of Neural ODEs on Paired Data
## Data preparation
* MNIST, CIFAR10, SVHN: Please set the download option as True in `main.py`.
* UCI regression: Please download the dataset from [here](https://drive.google.com/drive/u/5/folders/16L5Dy9qw3StCY4AvtP98KA5xDZrtcHV3).

## Training

### MNIST
```
python main.py --dataset=mnist --force_zero_prob=0.1 --label_ae_noise 3 --mlp_hidden_dim 2048 --name=0509_nonorm_ours_noise3_speed --total_steps 100000 --test_every 0.01 --in_proj_type mlp2 --out_proj_type mlp --dynamics linear --batch_size 1024 --lr_scheduler cos
```

### SVHN
```
python main.py --batch_size=1024 --dataset=svhn --total_steps=100000 --no_final_norm --no_out_norm --test_every=1960 --f_add_blocks 4 --latent_chan 256 --h_add_blocks 4 --lr_scheduler cos --proj_norm none --name=0512_h256_f_add4_h_add4_ours_nonorm_noise7_3e-4 --method ours --label_ae_noise=7 --force_zero_prob=0.1 --lr 3e-4
```

### CIFAR10
```
python main.py --batch_size=1024 --dataset=cifar10 --total_steps=100000 --no_final_norm --no_out_norm --test_every=1960 --f_add_blocks 4 --latent_chan 256 --h_add_blocks 4 --lr_scheduler cos --proj_norm none --name=0512_h256_f_add4_h_add4_ours_nonorm_noise10_3e-4_speed --method ours --label_ae_noise=10 --force_zero_prob=0.1 --lr 3e-4
```

### UCI
```
main.py --dataset uci --name [NAME] --task [TASK] --split_num 4 --force_zero_prob=0.1 --label_ae_noise 3.0 --dynamics linear --in_proj_type mlp --out_proj_type linear --total_steps 100000 --label_proj_type linear --test_every 0.01 --lr 0.003 --nonlinearity relu --latent_chan 64 --augment_t 8 --mlp_hidden_dim 64 --f_add_blocks 0 --h_add_blocks 4 --g_add_blocks 0 --method ours --batch_size 128 --patience 10
```

