seed = 42;
rng(seed);

%% load data
[y, X] = libsvmread('rcv1_train.binary');
[m,n] = size(X);
X = [X,ones(m,1)];
n = n+1;
y = (y+1)/2;

size_train = 5000;
size_test = 5000;
D = 300;

idx = randperm(m);
idx_train = idx(1:size_train);
X_train = X(idx_train,:);
y_train = y(idx_train);
idx_test = idx(size_train+1:size_train+size_test);
X_test = X(idx_test,:);
y_test = y(idx_test);

%% Define functions.
fun_g = @(x) -sum(log_logistic(y_train,X_train*x))/size_train;
grad_g = @(x) (X_train' * (1 ./ (1 + exp(-X_train * x)) - y_train))/size_train;
fun_f = @(x) -sum(log_logistic(y_test,X_test*x))/size_test;
grad_f = @(x) (X_test' * (1 ./ (1 + exp(-X_test * x)) - y_test))/size_train;


%% Parameters
Lf = eigs(X_test'*X_test,1)/(4*size_test);
Lg = eigs(X_train'*X_train,1)/(4*size_train);
epsilon_f = 1e-3;
epsilon_g = 1e-3;
maxiter = 2e3;

%% FCB-BiO-smooth algorithm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.maxiter = maxiter;
param.Lf = Lf;
param.Lg = Lg;
param.D = D;

disp('FCB-BiO-smooth starts')
[f_vec1,g_vec1,time_vec1,x1,vec_t_smooth,vec_t_time_smooth] = FCB_BiO_smooth(fun_f,grad_f,grad_g,fun_g,param,zeros(n,1)); 
disp('FCB-BiO-smooth Achieved!')

%% FCB-BiO-ns algorithm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.maxiter = maxiter;
param.eta = 2; 
param.D = D;

disp('FCB-BiO-Lipschitz starts')
[f_vec2,g_vec2,time_vec2,x2,vec_t,vec_t_time] = FCB_BiO_Lipschitz(fun_f,grad_f,grad_g,fun_g,param,zeros(n,1)); 
disp('FCB-BiO-Lipschitz Achieved!')

%% AGM-BiO algorithm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.Lf = Lf;
param.Lg = Lg;
param.T = 20;
param.D = D;
param.maxiter = maxiter;
disp('AGM-BiO starts');
[f_vec3,g_vec3,time_vec3,x3] = AGM_BiO(fun_f,grad_f,grad_g,fun_g,param,zeros(n,1));
disp('AGM-BiO Achieved!');

%% PB-APG algrotihm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.Lf = Lf;
param.Lg = Lg;
param.maxiter = maxiter;
param.gamma = 1e4;
param.T = 20;
disp('PB-APG starts');
[f_vec4,g_vec4,time_vec4,x4] = PB_APG(fun_f,grad_f,grad_g,fun_g,param,zeros(n,1));
disp('PB-APG Achieved!');

%% Bi-SG algorithm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.maxiter = maxiter;
param.T = 20;
param.D = D;
disp('Bi-SG starts');
[f_vec5,g_vec5,time_vec5,x5] = Bi_SG(fun_f,grad_f,grad_g,fun_g,param,zeros(n,1));
disp('Bi-SG Achieved!');

%% a-IRG Algorithm
param.maxiter=maxiter; 
param.D = D;

disp('a-IRG Algorithm starts')
[f_vec6,g_vec6,time_vec6,x6] = Alg_Projection(fun_f,grad_f,grad_g,fun_g,param,zeros(n,1));
disp('a-IRG Solution Achieved!');

%% CG-BiO algorithm
param.epsilonf = epsilon_f;
param.epsilong = epsilon_g;
param.maxiter=maxiter;
param.maxT = 20;
param.T0 = 1000;
param.D = D;
disp('CG-BiO starts');
[f_vec7,g_vec7,time_vec7,x7] = CG_BiO(fun_f,grad_f,grad_g,fun_g,param,zeros(n,1));
disp('CG-BiO Achieved!');

save('result.mat');
function out = log_logistic(y,X)
    out = 0*X;
    idx = y>0; 
    out(idx) = -log(1+exp(-X(idx)));
    out(~idx) = -log(1+exp(X(~idx))); 
end