function [f_vec,g_vec,time_vec,x] = PB_APG(fun_f,grad_f,grad_g,fun_g,param,x0)

epsilon_f= param.epsilonf;
epsilon_g= param.epsilong;
epsilon = max(epsilon_f,epsilon_g);
maxiter = param.maxiter;
gamma = param.gamma;
n = length(x0); % dimension
Lf = param.Lf;
Lg = param.Lg;
Lgamma = Lf + gamma * Lg;
D = param.D;

%% Compute g_k, using accelerated method
tic;
iter = 0; 
f_vec = [];
g_vec = [];
time_vec = [];
x = x0; y = x0;

f_vec = [f_vec;fun_f(x)];
g_vec = [g_vec;fun_g(x)];
time_vec = [time_vec;iter];
t = 1;

for k = 1:maxiter*10
    tmpx = y - 1/Lgamma*(grad_f(y)+gamma*grad_g(y));
    tmpt = t/2*(-t+sqrt(t^2+4));
    tmpx = proj_l2ball(tmpx,D);
    y = x + tmpt*(1/t-1)*(tmpx - x);
    t = tmpt;
    x = tmpx;

    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;fun_g(x)];
    time_vec = [time_vec;toc];
    if toc >= param.T
        break;
    end
end
x = x;
end
