load('result.mat')
num_markers = 10;
indices = find(time_vec1 <= 18); max_index = max(indices); time_vec1 = time_vec1(1:max_index); g_vec1 = g_vec1(1:max_index); f_vec1 = f_vec1(1:max_index);marker_idx1 = round(linspace(1, max_index, num_markers));
indices = find(time_vec2 <= 18); max_index = max(indices); time_vec2 = time_vec2(1:max_index); g_vec2 = g_vec2(1:max_index); f_vec2 = f_vec2(1:max_index);marker_idx2 = round(linspace(1, max_index, num_markers));
indices = find(time_vec3 <= 18); max_index = max(indices); time_vec3 = time_vec3(1:max_index); g_vec3 = g_vec3(1:max_index); f_vec3 = f_vec3(1:max_index);marker_idx3 = round(linspace(1, max_index, num_markers));
indices = find(time_vec4 <= 18); max_index = max(indices); time_vec4 = time_vec4(1:max_index); g_vec4 = g_vec4(1:max_index); f_vec4 = f_vec4(1:max_index);marker_idx4 = round(linspace(1, max_index, num_markers));
indices = find(time_vec5 <= 18); max_index = max(indices); time_vec5 = time_vec5(1:max_index); g_vec5 = g_vec5(1:max_index); f_vec5 = f_vec5(1:max_index);marker_idx5 = round(linspace(1, max_index, num_markers));
indices = find(time_vec6 <= 18); max_index = max(indices); time_vec6 = time_vec6(1:max_index); g_vec6 = g_vec6(1:max_index); f_vec6 = f_vec6(1:max_index);marker_idx6 = round(linspace(1, max_index, num_markers));
indices = find(time_vec7 <= 18); max_index = max(indices); time_vec7 = time_vec7(1:max_index); g_vec7 = g_vec7(1:max_index); f_vec7 = f_vec7(1:max_index);marker_idx7 = round(linspace(1, max_index, num_markers));
indices = find(time_vec8 <= 18); max_index = max(indices); time_vec8 = time_vec8(1:max_index); g_vec8 = g_vec8(1:max_index); f_vec8 = f_vec8(1:max_index);marker_idx8 = round(linspace(1, max_index, num_markers));

figure;
set(0,'defaulttextinterpreter','latex')
set(gcf,'DefaultLineLinewidth',5)
set(gcf,'DefaultLineMarkerSize',16);
set(gcf,'Position',[100, 100, 1400, 600]) 
set(gcf, 'PaperPositionMode', 'auto');

position1 = [0.1, 0.1, 0.346, 0.8];  
position2 = [0.53, 0.1, 0.45, 0.8];  


%% Lower-level
ax1 = subplot('Position', position1);
h3 = semilogy(time_vec3, abs(g_vec3-gstar), 's-', 'DisplayName', 'AGM-BiO', 'MarkerIndices', marker_idx3,'LineWidth',4, 'MarkerSize', 10);
hold on;
h4 = semilogy(time_vec4, abs(g_vec4-gstar), 'd-', 'DisplayName', 'PB-APG', 'MarkerIndices', marker_idx4,'LineWidth',4, 'MarkerSize', 10);
h5 = semilogy(time_vec5, abs(g_vec5-gstar), 's-', 'DisplayName', 'Bi-SG', 'MarkerIndices', marker_idx5,'LineWidth',4, 'MarkerSize', 10);
h6 = semilogy(time_vec6, abs(g_vec6-gstar), 'x-', 'DisplayName', 'a-IRG', 'MarkerIndices', marker_idx6,'LineWidth',4, 'MarkerSize', 10);
h7 = semilogy(time_vec7, abs(g_vec7-gstar), 'h-', 'DisplayName', 'CG-BiO', 'MarkerIndices', marker_idx7,'LineWidth',4, 'MarkerSize', 10);
h1 = semilogy(time_vec1, abs(g_vec1-gstar), 'o-', 'DisplayName', 'FC-BiO-smooth', 'MarkerIndices', marker_idx1,'LineWidth',4, 'MarkerSize', 10,'Color',[0.3010, 0.7450, 0.9330]);
h8 = semilogy(time_vec8, abs(g_vec8-gstar), '+-', 'DisplayName', 'Bisec-BiO', 'MarkerIndices', marker_idx8,'LineWidth',4, 'MarkerSize', 10,'Color',[0.6350, 0.0780, 0.1840] );
h2 = semilogy(time_vec2, abs(g_vec2-gstar), 'o-', 'DisplayName', 'FC-BiO-Lipschitz', 'MarkerIndices', marker_idx2,'LineWidth',4, 'MarkerSize', 10,'Color', [0.33, 0.78, 0.33]);

uistack(h1, 'top');
ylabel('$|g(\mathbf x_k)-g^*|$')
xlabel('time (s)')
set(gca, 'FontSize', 20);
set(gca, 'YLim', [1e-7, 1e4])
set(gca, 'XLim', [0, 19])
set(gca, 'YTick', [1e-6,1e-2,1e2])
grid on;
grid minor;
pbaspect([1 0.8 1]);

ax2 = subplot('Position', position2);
h3 = semilogy(time_vec3, abs(f_vec3-fstar), 's-', 'DisplayName', 'AGM-BiO', 'MarkerIndices', marker_idx3,'LineWidth',4, 'MarkerSize', 10);
hold on;
h4 = semilogy(time_vec4, abs(f_vec4-fstar), 'd-', 'DisplayName', 'PB-APG', 'MarkerIndices', marker_idx4,'LineWidth',4, 'MarkerSize', 10);
h5 = semilogy(time_vec5, abs(f_vec5-fstar), 's-', 'DisplayName', 'Bi-SG', 'MarkerIndices', marker_idx5,'LineWidth',4, 'MarkerSize', 10);
h6 = semilogy(time_vec6, abs(f_vec6-fstar), 'x-', 'DisplayName', 'a-IRG', 'MarkerIndices', marker_idx6,'LineWidth',4, 'MarkerSize', 10);
h7 = semilogy(time_vec7, abs(f_vec7-fstar), 'h-', 'DisplayName', 'CG-BiO', 'MarkerIndices', marker_idx7,'LineWidth',4, 'MarkerSize', 10);
h1 = semilogy(time_vec1, abs(f_vec1-fstar), 'o-', 'DisplayName', 'FC-BiO\textsuperscript{\texttt{sm}}', 'MarkerIndices', marker_idx1,'LineWidth',4, 'MarkerSize', 10,'Color',[0.3010, 0.7450, 0.9330]);
h8 = semilogy(time_vec8, abs(f_vec8-fstar), '+-', 'DisplayName', 'Bisec-BiO', 'MarkerIndices', marker_idx8,'LineWidth',4, 'MarkerSize', 10,'Color',[0.6350, 0.0780, 0.1840] );
h2 = semilogy(time_vec2, abs(f_vec2-fstar), 'o-', 'DisplayName', 'FC-BiO\textsuperscript{\texttt{Lip}}', 'MarkerIndices', marker_idx2,'LineWidth',4, 'MarkerSize', 10,'Color', [0.33, 0.78, 0.33]);

uistack(h1, 'top');
ylabel('$|f(\mathbf x_k)-f^*|$')
xlabel('time (s)')
set(gca, 'FontSize', 20);
set(gca, 'YLim', [1e-2, 0.6])
set(gca, 'XLim', [0, 19])
set(gca, 'YTick', [1e-2,1e-1])
grid on;
grid minor;
pbaspect([1 0.8 1]);

lgd = legend([h1,h2,h3,h4,h5,h6,h7,h8],'Interpreter', 'latex', 'Location', 'northeastoutside');
lgd.FontSize = 14;

exportgraphics(gcf, 'Figure_MNSP_FC-BiO.pdf', 'ContentType', 'vector');